/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.diagnostic.LogEventException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendWordSelectionHandlerBase
implements ExtendWordSelectionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase");

    public abstract boolean canSelect(PsiElement var1);

    public List<TextRange> select(PsiElement e2, CharSequence editorText, int cursorOffset, Editor editor) {
        TextRange originalRange = e2.getTextRange();
        if (originalRange.getEndOffset() > editorText.length()) {
            throw new LogEventException("Invalid element range in " + this.getClass(), "element=" + e2 + "; range=" + originalRange + "; text length=" + editorText.length() + "; editor=" + editor + "; committed=" + PsiDocumentManager.getInstance((Project)e2.getProject()).isCommitted(editor.getDocument()), new Attachment("editor_text.txt", editorText.toString()), new Attachment("psi_text.txt", e2.getText()));
        }
        List<TextRange> ranges = ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, true);
        if (ranges.size() == 1 && ranges.contains(originalRange)) {
            return ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, false);
        }
        return ranges;
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text2, int cursorOffset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase", "getMinimalTextRangeLength"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase", "getMinimalTextRangeLength"));
        }
        return 0;
    }

    public static List<TextRange> expandToWholeLine(CharSequence text2, @Nullable TextRange range, boolean isSymmetric) {
        TextRange expanded;
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (range == null) {
            return result2;
        }
        LOG.assertTrue(range.getEndOffset() <= text2.length());
        if (!StringUtil.contains((CharSequence)text2, (int)range.getStartOffset(), (int)range.getEndOffset(), (char)'\n')) {
            result2.add(range);
        }
        if ((expanded = ExtendWordSelectionHandlerBase.getExpandedRange(text2, range, isSymmetric)) != null) {
            result2.add(expanded);
        } else {
            result2.add(range);
        }
        return result2;
    }

    @Nullable
    private static TextRange getExpandedRange(CharSequence text2, TextRange range, boolean isSymmetric) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int index1 = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(startOffset - 1), (String)" \t");
        if (endOffset > startOffset && text2.charAt(endOffset - 1) == '\n') {
            --endOffset;
        }
        int textLength = text2.length();
        int index2 = Math.min(textLength, CharArrayUtil.shiftForward((CharSequence)text2, (int)endOffset, (String)" \t"));
        if (index1 < 0 || text2.charAt(index1) == '\n' || index2 == textLength || text2.charAt(index2) == '\n') {
            if (!isSymmetric) {
                if (index1 < 0 || text2.charAt(index1) == '\n') {
                    startOffset = index1 + 1;
                }
                if ((index2 == textLength || text2.charAt(index2) == '\n') && (endOffset = index2) < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
            if (!(index1 >= 0 && text2.charAt(index1) != '\n' || index2 != textLength && text2.charAt(index2) != '\n')) {
                startOffset = index1 + 1;
                endOffset = index2;
                if (endOffset < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
        }
        return null;
    }

    public static List<TextRange> expandToWholeLinesWithBlanks(CharSequence text2, TextRange range) {
        int blankLineEnd;
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine(text2, range, true));
        TextRange last = result2.isEmpty() ? range : (TextRange)result2.get(result2.size() - 1);
        int start2 = last.getStartOffset();
        int end = last.getEndOffset();
        while ((blankLineEnd = CharArrayUtil.shiftForward((CharSequence)text2, (int)end, (String)" \t")) < text2.length() && text2.charAt(blankLineEnd) == '\n') {
            end = blankLineEnd + 1;
        }
        if (end == last.getEndOffset()) {
            int blankLineStart;
            while (start2 > 0 && text2.charAt(start2 - 1) == '\n' && (blankLineStart = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(start2 - 2), (String)" \t")) > 0 && text2.charAt(blankLineStart) == '\n') {
                start2 = blankLineStart + 1;
            }
        }
        if (start2 != last.getStartOffset() || end != last.getEndOffset()) {
            result2.add(new TextRange(start2, end));
        }
        return result2;
    }

    public static List<TextRange> expandToWholeLine(CharSequence text2, TextRange range) {
        return ExtendWordSelectionHandlerBase.expandToWholeLine(text2, range, true);
    }
}

