/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.XmlTokenSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlSelectioner
extends AbstractWordSelectioner {
    private static final SelectWordUtil.CharCondition JAVA_IDENTIFIER_AND_HYPHEN_CONDITION = new SelectWordUtil.CharCondition(){

        @Override
        public boolean value(char ch) {
            return Character.isJavaIdentifierPart(ch) || ch == '-';
        }
    };

    @Override
    public boolean canSelect(PsiElement e2) {
        return HtmlSelectioner.canSelectElement(e2);
    }

    static boolean canSelectElement(PsiElement e2) {
        if (e2 instanceof XmlToken) {
            return HtmlUtil.hasHtml(e2.getContainingFile());
        }
        return false;
    }

    @Override
    public List<TextRange> select(PsiElement e2, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "select"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "select"));
        }
        ArrayList result2 = !(e2 instanceof XmlToken) || XmlTokenSelectioner.shouldSelectToken((XmlToken)e2) || ((XmlToken)e2).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS ? super.select(e2, editorText, cursorOffset, editor) : ContainerUtil.newArrayList();
        PsiElement parent = e2.getParent();
        if (parent instanceof XmlComment) {
            result2.addAll(HtmlSelectioner.expandToWholeLine(editorText, parent.getTextRange(), true));
        }
        PsiFile psiFile = e2.getContainingFile();
        HtmlSelectioner.addAttributeSelection(result2, editor, cursorOffset, editorText, e2);
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        for (Language lang : fileViewProvider.getLanguages()) {
            PsiFile langFile = fileViewProvider.getPsi(lang);
            if (langFile == psiFile) continue;
            HtmlSelectioner.addAttributeSelection(result2, editor, cursorOffset, editorText, fileViewProvider.findElementAt(cursorOffset, lang));
        }
        EditorHighlighter highlighter2 = HighlighterFactory.createHighlighter((Project)e2.getProject(), (VirtualFile)psiFile.getVirtualFile());
        highlighter2.setText(editorText);
        HtmlSelectioner.addTagSelection2(e2, result2);
        return result2;
    }

    private static void addTagSelection2(PsiElement e2, List<TextRange> result2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e2, XmlTag.class, (boolean)true);
        while (tag != null) {
            result2.add(tag.getTextRange());
            ASTNode tagStartEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
            ASTNode tagEndStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
            if (tagStartEnd != null && tagEndStart != null) {
                result2.add((TextRange)new UnfairTextRange(tagStartEnd.getTextRange().getEndOffset(), tagEndStart.getTextRange().getStartOffset()));
            }
            if (tagStartEnd != null) {
                result2.add(new TextRange(tag.getTextRange().getStartOffset(), tagStartEnd.getTextRange().getEndOffset()));
            }
            if (tagEndStart != null) {
                result2.add(new TextRange(tagEndStart.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset()));
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
        }
    }

    private static void addAttributeSelection(@NotNull List<TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @Nullable PsiElement e2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addAttributeSelection"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addAttributeSelection"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addAttributeSelection"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e2, XmlAttribute.class);
        if (attribute != null) {
            result2.add(attribute.getTextRange());
            XmlAttributeValue value2 = attribute.getValueElement();
            if (value2 != null) {
                if ("class".equalsIgnoreCase(attribute.getName())) {
                    HtmlSelectioner.addClassAttributeRanges(result2, editor, cursorOffset, editorText, value2);
                }
                TextRange range = value2.getTextRange();
                result2.add(range);
                if (value2.getFirstChild() != null && value2.getFirstChild().getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    result2.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
                }
            }
        }
    }

    @Override
    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text2, int cursorOffset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "getMinimalTextRangeLength"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "getMinimalTextRangeLength"));
        }
        if (WebEditorOptions.getInstance().isSelectWholeCssIdentifierOnDoubleClick()) {
            TextRange valueTextRange;
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
            XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
            if (attribute != null && attributeValue != null && "class".equalsIgnoreCase(attribute.getName()) && !(valueTextRange = attributeValue.getValueTextRange()).isEmpty()) {
                int start2;
                int end = cursorOffset;
                for (start2 = cursorOffset; start2 > valueTextRange.getStartOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text2.charAt(start2 - 1)); --start2) {
                }
                while (end < valueTextRange.getEndOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text2.charAt(end + 1))) {
                    ++end;
                }
                return end - start2;
            }
        }
        return super.getMinimalTextRangeLength(element, text2, cursorOffset);
    }

    private static void addClassAttributeRanges(@NotNull List<TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @NotNull XmlAttributeValue attributeValue) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addClassAttributeRanges"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addClassAttributeRanges"));
        }
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addClassAttributeRanges"));
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/codeInsight/editorActions/HtmlSelectioner", "addClassAttributeRanges"));
        }
        TextRange attributeValueTextRange = attributeValue.getTextRange();
        LinkedList wordRanges = ContainerUtil.newLinkedList();
        SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editorText, cursorOffset, wordRanges, JAVA_IDENTIFIER_AND_HYPHEN_CONDITION);
        for (TextRange range : wordRanges) {
            if (!attributeValueTextRange.contains(range)) continue;
            result2.add(range);
        }
    }
}

