/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class MatchBraceAction
extends EditorAction {
    public MatchBraceAction() {
        super((EditorActionHandler)new MyHandler());
    }

    @NotNull
    private static FileType getFileType(PsiFile file2, int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)file2, (int)offset).getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/MatchBraceAction", "getFileType"));
        }
        return fileType;
    }

    private static void moveCaret(Editor editor, Caret caret, int offset) {
        caret.removeSelection();
        caret.moveToOffset(offset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
    }

    private static class MyHandler
    extends EditorActionHandler {
        public MyHandler() {
            super(true);
        }

        public void execute(Editor editor, DataContext dataContext) {
            HighlighterIterator i2;
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (file2 == null) {
                return;
            }
            Caret caret = editor.getCaretModel().getCurrentCaret();
            EditorHighlighter highlighter2 = ((EditorEx)editor).getHighlighter();
            CharSequence text2 = editor.getDocument().getCharsSequence();
            int offset = caret.getOffset();
            FileType fileType = MatchBraceAction.getFileType(file2, offset);
            HighlighterIterator iterator2 = highlighter2.createIterator(offset);
            if (iterator2.atEnd()) {
                --offset;
            } else if (!BraceMatchingUtil.isLBraceToken(iterator2, text2, fileType) && --offset >= 0 && !BraceMatchingUtil.isRBraceToken(i2 = highlighter2.createIterator(offset), text2, MatchBraceAction.getFileType(file2, i2.getStart()))) {
                ++offset;
            }
            if (offset < 0) {
                return;
            }
            iterator2 = highlighter2.createIterator(offset);
            fileType = MatchBraceAction.getFileType(file2, iterator2.getStart());
            while (!BraceMatchingUtil.isLBraceToken(iterator2, text2, fileType) && !BraceMatchingUtil.isRBraceToken(iterator2, text2, fileType)) {
                if (iterator2.getStart() == 0) {
                    return;
                }
                iterator2.retreat();
                offset = iterator2.getStart();
            }
            if (BraceMatchingUtil.matchBrace(text2, fileType, iterator2, true)) {
                MatchBraceAction.moveCaret(editor, caret, iterator2.getEnd());
                return;
            }
            iterator2 = highlighter2.createIterator(offset);
            if (BraceMatchingUtil.matchBrace(text2, fileType, iterator2, false)) {
                MatchBraceAction.moveCaret(editor, caret, iterator2.getStart());
            }
        }
    }
}

