/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.InjectedCaret;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.SelectWordHandler");
    private final EditorActionHandler myOriginalHandler;

    public SelectWordHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordHandler", "doExecute"));
        }
        assert (caret != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: execute(editor='" + editor + "')");
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()))) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        TextRange range = SelectWordHandler.selectWord(caret, project2);
        if (editor instanceof EditorWindow && (range == null || !SelectWordHandler.isInsideEditableInjection((EditorWindow)editor, range, project2) || TextRange.from((int)0, (int)editor.getDocument().getTextLength()).equals((Object)new TextRange(caret.getSelectionStart(), caret.getSelectionEnd())))) {
            editor = ((EditorWindow)editor).getDelegate();
            caret = ((InjectedCaret)caret).getDelegate();
            range = SelectWordHandler.selectWord(caret, project2);
        }
        if (range == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        } else {
            caret.setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static boolean isInsideEditableInjection(EditorWindow editor, TextRange range, Project project2) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return true;
        }
        List editables = InjectedLanguageManager.getInstance((Project)project2).intersectWithAllEditableFragments(file2, range);
        return editables.size() == 1 && range.equals(editables.get(0));
    }

    @Nullable(value="null means unable to select")
    private static TextRange selectWord(@NotNull Caret caret, @NotNull Project project2) {
        PsiElement elementInOtherTree;
        PsiElement anotherElement;
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/editorActions/SelectWordHandler", "selectWord"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/SelectWordHandler", "selectWord"));
        }
        Document document = caret.getEditor().getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.select.word");
        int caretOffset = SelectWordHandler.adjustCaretOffset(caret);
        PsiElement element = SelectWordHandler.findElementAt(file2, caretOffset);
        if (element instanceof PsiWhiteSpace && caretOffset > 0 && !((anotherElement = SelectWordHandler.findElementAt(file2, caretOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        while (element instanceof PsiWhiteSpace || element != null && StringUtil.isEmptyOrSpaces((String)element.getText())) {
            while (element.getNextSibling() == null) {
                if (element instanceof PsiFile) {
                    return null;
                }
                PsiElement parent = element.getParent();
                PsiElement[] children2 = parent.getChildren();
                if (children2.length > 0 && children2[children2.length - 1] == element) {
                    element = parent;
                    continue;
                }
                element = parent;
                break;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            if ((element = element.getNextSibling()) == null) {
                return null;
            }
            TextRange range2 = element.getTextRange();
            if (range2 == null) {
                return null;
            }
            caretOffset = range2.getStartOffset();
        }
        if (element instanceof OuterLanguageElement && ((elementInOtherTree = file2.getViewProvider().findElementAt(element.getTextOffset(), element.getLanguage())) == null || elementInOtherTree.getContainingFile() != element.getContainingFile())) {
            while (elementInOtherTree != null && elementInOtherTree.getPrevSibling() == null) {
                elementInOtherTree = elementInOtherTree.getParent();
            }
            if (elementInOtherTree != null) {
                assert (elementInOtherTree.getTextOffset() == caretOffset);
                element = elementInOtherTree;
            }
        }
        SelectWordHandler.checkElementRange(document, element);
        TextRange selectionRange = new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
        Ref minimumRange = new Ref((Object)new TextRange(0, document.getTextLength()));
        SelectWordUtil.processRanges(element, document.getCharsSequence(), caretOffset, caret.getEditor(), (Processor<TextRange>)((Processor)range -> {
            if (range.contains(selectionRange) && !range.equals((Object)selectionRange) && ((TextRange)minimumRange.get()).contains(range)) {
                minimumRange.set(range);
                return true;
            }
            return false;
        }));
        return (TextRange)minimumRange.get();
    }

    private static void checkElementRange(Document document, PsiElement element) {
        if (element != null && element.getTextRange().getEndOffset() > document.getTextLength()) {
            throw new AssertionError((Object)DebugUtil.diagnosePsiDocumentInconsistency(element, document));
        }
    }

    private static int adjustCaretOffset(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/editorActions/SelectWordHandler", "adjustCaretOffset"));
        }
        int caretOffset = caret.getOffset();
        if (caretOffset == 0) {
            return caretOffset;
        }
        CharSequence text2 = caret.getEditor().getDocument().getCharsSequence();
        char prev = text2.charAt(caretOffset - 1);
        if (caretOffset < text2.length() && !Character.isJavaIdentifierPart(text2.charAt(caretOffset)) && Character.isJavaIdentifierPart(prev)) {
            return caretOffset - 1;
        }
        if ((caretOffset == text2.length() || Character.isWhitespace(text2.charAt(caretOffset))) && !Character.isWhitespace(prev)) {
            return caretOffset - 1;
        }
        return caretOffset;
    }

    @Nullable
    private static PsiElement findElementAt(@NotNull PsiFile file2, int caretOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/SelectWordHandler", "findElementAt"));
        }
        PsiElement elementAt = file2.findElementAt(caretOffset);
        if (elementAt != null && SelectWordHandler.isLanguageExtension(file2, elementAt)) {
            return file2.getViewProvider().findElementAt(caretOffset, file2.getLanguage());
        }
        return elementAt;
    }

    private static boolean isLanguageExtension(@NotNull PsiFile file2, @NotNull PsiElement elementAt) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/SelectWordHandler", "isLanguageExtension"));
        }
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/codeInsight/editorActions/SelectWordHandler", "isLanguageExtension"));
        }
        Language elementLanguage = elementAt.getLanguage();
        if (file2.getLanguage() instanceof CompositeLanguage) {
            Language[] extensions;
            CompositeLanguage compositeLanguage = (CompositeLanguage)file2.getLanguage();
            for (Language extension : extensions = compositeLanguage.getLanguageExtensionsForFile(file2)) {
                if (extension != elementLanguage) continue;
                return true;
            }
        }
        return false;
    }
}

