/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageQuoteHandling;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedHandler
extends TypedActionHandlerBase {
    private static final Set<Character> COMPLEX_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\'')));
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.TypedHandler");
    private static final Map<FileType, QuoteHandler> quoteHandlers = new HashMap<FileType, QuoteHandler>();
    private static final Map<Class<? extends Language>, QuoteHandler> ourBaseLanguageQuoteHandlers = new HashMap<Class<? extends Language>, QuoteHandler>();

    public TypedHandler(TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file2, @NotNull Editor editor) {
        FileType fileFileType;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "getQuoteHandler"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "getQuoteHandler"));
        }
        FileType fileType = TypedHandler.getFileType(file2, editor);
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandlerForType(fileType);
        if (quoteHandler == null && (fileFileType = file2.getFileType()) != fileType) {
            quoteHandler = TypedHandler.getQuoteHandlerForType(fileFileType);
        }
        if (quoteHandler == null) {
            return TypedHandler.getLanguageQuoteHandler(file2.getViewProvider().getBaseLanguage());
        }
        return quoteHandler;
    }

    public static QuoteHandler getLanguageQuoteHandler(Language baseLanguage) {
        for (Map.Entry<Class<? extends Language>, QuoteHandler> entry : ourBaseLanguageQuoteHandlers.entrySet()) {
            if (!entry.getKey().isInstance(baseLanguage)) continue;
            return entry.getValue();
        }
        return (QuoteHandler)LanguageQuoteHandling.INSTANCE.forLanguage(baseLanguage);
    }

    private static FileType getFileType(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageFileType associatedFileType;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "getFileType"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "getFileType"));
        }
        FileType fileType = file2.getFileType();
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)file2.getProject());
        if (language != null && language != PlainTextLanguage.INSTANCE && (associatedFileType = language.getAssociatedFileType()) != null) {
            fileType = associatedFileType;
        }
        return fileType;
    }

    public static void registerBaseLanguageQuoteHandler(@NotNull Class<? extends Language> languageClass, @NotNull QuoteHandler quoteHandler) {
        if (languageClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageClass", "com/intellij/codeInsight/editorActions/TypedHandler", "registerBaseLanguageQuoteHandler"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "registerBaseLanguageQuoteHandler"));
        }
        ourBaseLanguageQuoteHandlers.put(languageClass, quoteHandler);
    }

    public static QuoteHandler getQuoteHandlerForType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/editorActions/TypedHandler", "getQuoteHandlerForType"));
        }
        if (!quoteHandlers.containsKey(fileType)) {
            QuoteHandlerEP[] handlerEPs;
            QuoteHandler handler2 = null;
            for (QuoteHandlerEP ep : handlerEPs = (QuoteHandlerEP[])Extensions.getExtensions(QuoteHandlerEP.EP_NAME)) {
                if (!ep.fileType.equals(fileType.getName())) continue;
                handler2 = ep.getHandler();
                break;
            }
            quoteHandlers.put(fileType, handler2);
        }
        return quoteHandlers.get(fileType);
    }

    @Deprecated
    public static void registerQuoteHandler(@NotNull FileType fileType, @NotNull QuoteHandler quoteHandler) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/editorActions/TypedHandler", "registerQuoteHandler"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "registerQuoteHandler"));
        }
        quoteHandlers.put(fileType, quoteHandler);
    }

    @Override
    public void beforeExecute(@NotNull Editor editor, char c2, @NotNull DataContext context2, @NotNull ActionPlan plan) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "beforeExecute"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/editorActions/TypedHandler", "beforeExecute"));
        }
        if (plan == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plan", "com/intellij/codeInsight/editorActions/TypedHandler", "beforeExecute"));
        }
        if (COMPLEX_CHARS.contains(Character.valueOf(c2)) || Character.isSurrogate(c2)) {
            return;
        }
        if (editor.isInsertMode()) {
            int offset = plan.getCaretOffset();
            plan.replace(offset, offset, String.valueOf(c2));
        }
        super.beforeExecute(editor, c2, context2, plan);
    }

    public void execute(final @NotNull Editor originalEditor, final char charTyped, final @NotNull DataContext dataContext) {
        PsiFile originalFile;
        if (originalEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalEditor", "com/intellij/codeInsight/editorActions/TypedHandler", "execute"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/TypedHandler", "execute"));
        }
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null || (originalFile = PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project2)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)originalEditor)) {
            return;
        }
        final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        final Document originalDocument = originalEditor.getDocument();
        originalEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                TypedHandlerDelegate.Result result2;
                Editor editor;
                if (psiDocumentManager.isDocumentBlockedByPsi(originalDocument)) {
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(originalDocument);
                }
                PsiFile file2 = (editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile)) == originalEditor ? originalFile : psiDocumentManager.getPsiFile(editor.getDocument());
                TypedHandlerDelegate[] delegates = (TypedHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)TypedHandlerDelegate.EP_NAME);
                if (caret == originalEditor.getCaretModel().getPrimaryCaret()) {
                    boolean handled = false;
                    TypedHandlerDelegate[] typedHandlerDelegateArray = delegates;
                    int n2 = typedHandlerDelegateArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        TypedHandlerDelegate delegate2 = typedHandlerDelegateArray[i2];
                        result2 = delegate2.checkAutoPopup(charTyped, project2, editor, file2);
                        boolean bl = handled = result2 == TypedHandlerDelegate.Result.STOP;
                        if (result2 != TypedHandlerDelegate.Result.CONTINUE) break;
                    }
                    if (!handled) {
                        TypedHandler.autoPopupCompletion(editor, charTyped, project2, file2);
                        TypedHandler.autoPopupParameterInfo(editor, charTyped, project2, file2);
                    }
                }
                if (!editor.isInsertMode()) {
                    TypedHandler.type(originalEditor, charTyped);
                    return;
                }
                for (TypedHandlerDelegate delegate3 : delegates) {
                    TypedHandlerDelegate.Result result3 = delegate3.beforeSelectionRemoved(charTyped, project2, editor, file2);
                    if (result3 == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result3 == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                FileType fileType = TypedHandler.getFileType(file2, editor);
                for (TypedHandlerDelegate delegate2 : delegates) {
                    result2 = delegate2.beforeCharTyped(charTyped, project2, editor, file2, fileType);
                    if (result2 == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result2 == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                if (')' == charTyped || ']' == charTyped || '}' == charTyped ? FileTypes.PLAIN_TEXT != fileType && TypedHandler.handleRParen(editor, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped || '`' == charTyped) && TypedHandler.handleQuote(editor, charTyped, file2)) {
                    return;
                }
                long modificationStampBeforeTyping = editor.getDocument().getModificationStamp();
                TypedHandler.type(originalEditor, charTyped);
                AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, dataContext, modificationStampBeforeTyping);
                if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && fileType != FileTypes.PLAIN_TEXT) {
                    TypedHandler.handleAfterLParen(editor, fileType, charTyped);
                } else if ('}' == charTyped) {
                    TypedHandler.indentClosingBrace(project2, editor);
                } else if (')' == charTyped) {
                    TypedHandler.indentClosingParenth(project2, editor);
                }
                for (TypedHandlerDelegate delegate4 : delegates) {
                    TypedHandlerDelegate.Result result4 = delegate4.charTyped(charTyped, project2, editor, file2);
                    if (result4 == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result4 == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                if ('{' == charTyped) {
                    TypedHandler.indentOpenedBrace(project2, editor);
                } else if ('(' == charTyped) {
                    TypedHandler.indentOpenedParenth(project2, editor);
                }
            }
        });
    }

    private static void type(Editor editor, char charTyped) {
        CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]));
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(charTyped), (boolean)true, (boolean)true);
    }

    private static void autoPopupParameterInfo(@NotNull Editor editor, char charTyped, @NotNull Project project2, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "autoPopupParameterInfo"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "autoPopupParameterInfo"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "autoPopupParameterInfo"));
        }
        if (!(charTyped != '(' && charTyped != ',' || TypedHandler.isInsideStringLiteral(editor, file2))) {
            AutoPopupController.getInstance(project2).autoPopupParameterInfo(editor, null);
        }
    }

    public static void autoPopupCompletion(@NotNull Editor editor, char charTyped, @NotNull Project project2, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "autoPopupCompletion"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "autoPopupCompletion"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "autoPopupCompletion"));
        }
        if (charTyped == '.' || TypedHandler.isAutoPopup(editor, file2, charTyped)) {
            AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, null);
        }
    }

    public static void commitDocumentIfCurrentCaretIsNotTheFirstOne(@NotNull Editor editor, @NotNull Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "commitDocumentIfCurrentCaretIsNotTheFirstOne"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "commitDocumentIfCurrentCaretIsNotTheFirstOne"));
        }
        if (ContainerUtil.getFirstItem((List)editor.getCaretModel().getAllCarets()) != editor.getCaretModel().getCurrentCaret()) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        }
    }

    private static boolean isAutoPopup(@NotNull Editor editor, @NotNull PsiFile file2, char charTyped) {
        PsiElement element;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "isAutoPopup"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "isAutoPopup"));
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset >= 0 && (element = file2.findElementAt(offset)) != null) {
            List list2 = CompletionContributor.forLanguage((Language)element.getLanguage());
            for (CompletionContributor contributor : list2) {
                if (!contributor.invokeAutoPopup(element, charTyped)) continue;
                LOG.debug(contributor + " requested completion autopopup when typing '" + charTyped + "'");
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideStringLiteral(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "isInsideStringLiteral"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "isInsideStringLiteral"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (definition != null) {
            ASTNode parentNode;
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node = element.getNode();
            if (node == null) {
                return false;
            }
            IElementType elementType = node.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent != null && (parentNode = parent.getNode()) != null && stringLiteralElements.contains(parentNode.getElementType())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
        }
        if (oldFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFile", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
        }
        Editor editor2 = TypedHandler.injectedEditorIfCharTypedIsSignificant((int)charTyped, editor, oldFile);
        if (editor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
        }
        return editor2;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(int charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
        }
        if (oldFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFile", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
        }
        int offset = editor.getCaretModel().getOffset();
        for (DocumentWindow documentWindow : InjectedLanguageUtil.getCachedInjectedDocuments(oldFile)) {
            PsiFile injectedFile;
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset) || (injectedFile = PsiDocumentManager.getInstance((Project)oldFile.getProject()).getPsiFile((Document)documentWindow)) == null) continue;
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
            TextRange hostRange = documentWindow.getHostRange(offset);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if ((sequence.length() <= offset || charTyped == Character.codePointAt(sequence, offset)) && (hostRange == null || !hostRange.contains(offset))) continue;
            Editor editor2 = injectedEditor;
            if (editor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
            }
            return editor2;
        }
        Editor editor3 = editor;
        if (editor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/TypedHandler", "injectedEditorIfCharTypedIsSignificant"));
        }
        return editor3;
    }

    private static void handleAfterLParen(@NotNull Editor editor, @NotNull FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "handleAfterLParen"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/editorActions/TypedHandler", "handleAfterLParen"));
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator2.retreat();
        }
        if (iterator2.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (iterator2.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator2.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator2, fileText, fileType)) {
            return;
        }
        if (!iterator2.atEnd()) {
            iterator2.advance();
            if (!iterator2.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, iterator2.getTokenType(), fileType)) {
                return;
            }
            iterator2.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator2 = ((EditorEx)editor).getHighlighter().createIterator(lparenOffset), true, true))) {
            String text2;
            if (lparenChar == '(') {
                text2 = ")";
            } else if (lparenChar == '[') {
                text2 = "]";
            } else if (lparenChar == '<') {
                text2 = ">";
            } else if (lparenChar == '{') {
                text2 = "}";
            } else {
                throw new AssertionError((Object)("Unknown char " + lparenChar));
            }
            editor.getDocument().insertString(offset, (CharSequence)text2);
        }
    }

    public static boolean handleRParen(@NotNull Editor editor, @NotNull FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "handleRParen"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/editorActions/TypedHandler", "handleRParen"));
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getEnd() - iterator2.getStart() != 1 || editor.getDocument().getCharsSequence().charAt(iterator2.getStart()) != charTyped) {
            return false;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (!braceMatcher.isRBraceToken(iterator2, text2 = editor.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator2.getTokenType();
        iterator2.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, lparenTokenType, text2, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t2 : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t2 != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, t2, text2, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text2, fileType, iterator2 = ((EditorEx)editor).getHighlighter().createIterator(lparenthOffset), true, true))) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean handleQuote(@NotNull Editor editor, char quote, @NotNull PsiFile file2) {
        CharSequence closingQuote;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "handleQuote"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/TypedHandler", "handleQuote"));
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        if (quoteHandler == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int length = document.getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor, quoteHandler, offset)) {
            return false;
        }
        if (offset < length && chars.charAt(offset) == quote && TypedHandler.isClosingQuote(editor, quoteHandler, offset)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        TypedHandler.type(editor, quote);
        offset = editor.getCaretModel().getOffset();
        if (quoteHandler instanceof MultiCharQuoteHandler && (closingQuote = TypedHandler.getClosingQuote(editor, (MultiCharQuoteHandler)quoteHandler, offset)) != null && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, closingQuote);
            return true;
        }
        if (TypedHandler.isOpeningQuote(editor, quoteHandler, offset - 1) && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, (CharSequence)String.valueOf(quote));
        }
        return true;
    }

    private static boolean isClosingQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "isClosingQuote"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "isClosingQuote"));
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isClosingQuote(iterator2, offset);
    }

    @Nullable
    private static CharSequence getClosingQuote(@NotNull Editor editor, @NotNull MultiCharQuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "getClosingQuote"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "getClosingQuote"));
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return null;
        }
        return quoteHandler.getClosingQuote(iterator2, offset);
    }

    private static boolean isOpeningQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "isOpeningQuote"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "isOpeningQuote"));
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator2, offset);
    }

    private static boolean hasNonClosedLiterals(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "hasNonClosedLiterals"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "hasNonClosedLiterals"));
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor, iterator2, offset);
    }

    private static boolean isTypingEscapeQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "isTypingEscapeQuote"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "isTypingEscapeQuote"));
        }
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\\");
        int slashCount = offset - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor, quoteHandler, offset);
    }

    private static boolean isInsideLiteral(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "isInsideLiteral"));
        }
        if (quoteHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteHandler", "com/intellij/codeInsight/editorActions/TypedHandler", "isInsideLiteral"));
        }
        if (offset == 0) {
            return false;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator2);
    }

    private static void indentClosingBrace(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "indentClosingBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "indentClosingBrace"));
        }
        TypedHandler.indentBrace(project2, editor, '}');
    }

    static void indentOpenedBrace(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "indentOpenedBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "indentOpenedBrace"));
        }
        TypedHandler.indentBrace(project2, editor, '{');
    }

    private static void indentOpenedParenth(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "indentOpenedParenth"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "indentOpenedParenth"));
        }
        TypedHandler.indentBrace(project2, editor, '(');
    }

    private static void indentClosingParenth(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "indentClosingParenth"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "indentClosingParenth"));
        }
        TypedHandler.indentBrace(project2, editor, ')');
    }

    private static void indentBrace(@NotNull Project project2, @NotNull Editor editor, char braceChar) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "indentBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "indentBrace"));
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            PsiElement element = file2.findElementAt(offset);
            if (element == null) {
                return;
            }
            EditorHighlighter highlighter2 = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator2 = highlighter2.createIterator(offset);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator2, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator2, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator2, chars, fileType) && offset > 0) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen(highlighter2.createIterator(offset - 1), braceMatcher.getOppositeBraceTokenType(iterator2.getTokenType()), editor.getDocument().getCharsSequence(), fileType);
            }
            if (element.getNode() != null && isBrace) {
                int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/TypedHandler", "lambda$indentBrace$0"));
                    }
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/TypedHandler", "lambda$indentBrace$0"));
                    }
                    try {
                        int newOffset;
                        if (finalLBraceOffset != -1) {
                            RangeMarker marker = document.createRangeMarker(offset, offset + 1);
                            CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)file2, finalLBraceOffset, offset, true);
                            newOffset = marker.getStartOffset();
                            marker.dispose();
                        } else {
                            newOffset = CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, offset);
                        }
                        editor.getCaretModel().moveToOffset(newOffset + 1);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                    catch (IncorrectOperationException e2) {
                        LOG.error((Throwable)e2);
                    }
                });
            }
        }
    }
}

