/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterAfterJavadocTagHandler
extends EnterHandlerDelegateAdapter {
    private static final Context NOT_MATCHED_CONTEXT = new Context();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "preprocessEnter"));
        }
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int line = document.getLineNumber(((Integer)caretOffset.get()).intValue());
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file2, text2, (int)((Integer)caretOffset.get()), start2);
        if (!commentContext.docAsterisk) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Context context2 = EnterAfterJavadocTagHandler.parse(text2, start2, end, (Integer)caretOffset.get());
        if (!context2.shouldGenerateLine()) {
            return context2.shouldIndent() ? EnterHandlerDelegate.Result.DefaultForceIndent : EnterHandlerDelegate.Result.Continue;
        }
        String indentInsideJavadoc = CodeDocumentationUtil.getIndentInsideJavadoc(document, (Integer)caretOffset.get());
        boolean restoreCaret = false;
        if ((Integer)caretOffset.get() != context2.endTagStartOffset) {
            editor.getCaretModel().moveToOffset(context2.endTagStartOffset);
            restoreCaret = true;
        }
        originalHandler.execute(editor, dataContext);
        Project project2 = editor.getProject();
        if (indentInsideJavadoc != null && project2 != null && CodeStyleSettingsManager.getSettings((Project)project2).JD_LEADING_ASTERISKS_ARE_ENABLED) {
            document.insertString(editor.getCaretModel().getOffset(), (CharSequence)("*" + indentInsideJavadoc));
        }
        if (restoreCaret) {
            editor.getCaretModel().moveToOffset(((Integer)caretOffset.get()).intValue());
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    static Context parse(@NotNull CharSequence text2, int startOffset, int endOffset, int offset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "parse"));
        }
        int asteriskOffset = StringUtil.indexOf((CharSequence)text2, (char)'*', (int)startOffset, (int)endOffset);
        if (asteriskOffset < 0) {
            Context context2 = NOT_MATCHED_CONTEXT;
            if (context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "parse"));
            }
            return context2;
        }
        startOffset = asteriskOffset + 1;
        int startTagStartOffset = -1;
        int startTagEndOffset = -1;
        HashSet<CharSequence> closedTags = new HashSet<CharSequence>();
        CharSequence startTag = null;
        for (int i2 = offset - 1; i2 >= startOffset; --i2) {
            CharSequence tag;
            char c2 = text2.charAt(i2);
            if (c2 == ' ' || c2 == '\t') continue;
            if (c2 == '>' && startTagEndOffset < 0) {
                if (i2 > startOffset && text2.charAt(i2 - 1) == '/') break;
                startTagEndOffset = i2;
                continue;
            }
            if (c2 != '<') continue;
            if (startTagEndOffset < 0 || i2 >= endOffset) break;
            if (text2.charAt(i2 + 1) == '/') {
                tag = text2.subSequence(i2 + 2, startTagEndOffset);
                closedTags.add(tag);
                startTagEndOffset = -1;
                continue;
            }
            tag = text2.subSequence(i2 + 1, startTagEndOffset);
            if (closedTags.remove(tag)) {
                startTagEndOffset = -1;
                continue;
            }
            startTagStartOffset = i2;
            startTag = text2.subSequence(i2 + 1, startTagEndOffset + 1);
            break;
        }
        if (startTagStartOffset < 0 || startTagEndOffset < 0) {
            Context context3 = NOT_MATCHED_CONTEXT;
            if (context3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "parse"));
            }
            return context3;
        }
        int endTagStartOffset = -1;
        for (int i3 = offset; i3 < endOffset; ++i3) {
            char c3 = text2.charAt(i3);
            if (c3 != '<' || i3 >= endOffset || text2.charAt(i3 + 1) != '/' || startTag == null || !CharArrayUtil.regionMatches((CharSequence)text2, (int)(i3 + 2), (int)endOffset, startTag)) continue;
            endTagStartOffset = i3;
            break;
        }
        Context context4 = new Context(text2, startTagEndOffset, endTagStartOffset, offset);
        if (context4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler", "parse"));
        }
        return context4;
    }

    static class Context {
        public final int startTagEndOffset;
        public final int endTagStartOffset;
        @Nullable
        private final CharSequence myText;
        private final int myOffset;

        Context() {
            this(null, -1, -1, -1);
        }

        Context(@Nullable CharSequence text2, int startTagEndOffset, int endTagStartOffset, int offset) {
            this.myText = text2;
            this.startTagEndOffset = startTagEndOffset;
            this.endTagStartOffset = endTagStartOffset;
            this.myOffset = offset;
        }

        public boolean shouldGenerateLine() {
            return this.endTagStartOffset >= 0 && this.shouldIndent();
        }

        public boolean shouldIndent() {
            if (this.startTagEndOffset < 0 || this.myText == null) {
                return false;
            }
            for (int i2 = this.startTagEndOffset + 1; i2 < this.myOffset; ++i2) {
                char c2 = this.myText.charAt(i2);
                if (c2 == ' ' || c2 == '\t') continue;
                return false;
            }
            return true;
        }
    }
}

