/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterAfterUnmatchedBraceHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "preprocessEnter"));
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        if (!this.isApplicable(file2, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int maxRBraceCount = this.getMaxRBraceCount(file2, editor, caretOffset);
        if (maxRBraceCount > 0) {
            this.insertRBraces(file2, editor, caretOffset, this.getRBraceOffset(file2, editor, caretOffset), this.generateStringToInsert(editor, caretOffset, maxRBraceCount));
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public boolean isApplicable(@NotNull PsiFile file2, int caretOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "isApplicable"));
        }
        return true;
    }

    protected int getMaxRBraceCount(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getMaxRBraceCount"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getMaxRBraceCount"));
        }
        if (!CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER) {
            return 0;
        }
        return Math.max(0, EnterAfterUnmatchedBraceHandler.getUnmatchedLBracesNumberBefore(editor, caretOffset, file2.getFileType()));
    }

    @NotNull
    protected String generateStringToInsert(@NotNull Editor editor, int caretOffset, int maxRBraceCount) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "generateStringToInsert"));
        }
        assert (maxRBraceCount > 0);
        CharSequence text2 = editor.getDocument().getCharsSequence();
        int bracesToInsert = 0;
        for (int i2 = caretOffset - 1; i2 >= 0 && bracesToInsert < maxRBraceCount; --i2) {
            char c2 = text2.charAt(i2);
            if (c2 == '{') {
                ++bracesToInsert;
                continue;
            }
            if (this.isStopChar(c2)) break;
        }
        String string2 = StringUtil.repeatSymbol((char)'}', (int)Math.max(bracesToInsert, 1));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "generateStringToInsert"));
        }
        return string2;
    }

    protected boolean isStopChar(char c2) {
        return " \n\t".indexOf(c2) < 0;
    }

    protected int getRBraceOffset(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset) {
        int fileLength;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getRBraceOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "getRBraceOffset"));
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        int offset = CharArrayUtil.shiftForward((CharSequence)text2, (int)caretOffset, (String)" \t");
        if (offset < (fileLength = text2.length()) && ")];,%<?".indexOf(text2.charAt(offset)) < 0) {
            offset = (Integer)this.calculateOffsetToInsertClosingBrace((PsiFile)file2, (CharSequence)text2, (int)offset).second;
        }
        return Math.min(offset, fileLength);
    }

    protected void insertRBraces(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "insertRBraces"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "insertRBraces"));
        }
        Document document = editor.getDocument();
        this.insertRBracesAtPosition(document, caretOffset, rBracesInsertOffset, generatedRBraces);
        this.formatCodeFragmentBetweenBraces(file2, document, caretOffset, rBracesInsertOffset, generatedRBraces);
    }

    protected void insertRBracesAtPosition(Document document, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        document.insertString(rBracesInsertOffset, (CharSequence)("\n" + generatedRBraces));
        document.insertString(caretOffset, (CharSequence)"\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatCodeFragmentBetweenBraces(@NotNull PsiFile file2, @NotNull Document document, int caretOffset, int rBracesInsertOffset, String generatedRBraces) {
        boolean closingBraceIndentAdjusted;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "formatCodeFragmentBetweenBraces"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "formatCodeFragmentBetweenBraces"));
        }
        Project project2 = file2.getProject();
        long stamp = document.getModificationStamp();
        try {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, new TextRange(caretOffset, rBracesInsertOffset + 2));
        }
        catch (IncorrectOperationException e2) {
            try {
                LOG.error((Throwable)e2);
            }
            catch (Throwable throwable) {
                boolean closingBraceIndentAdjusted2 = stamp != document.getModificationStamp();
                document.deleteString(caretOffset, caretOffset + 1);
                throw throwable;
            }
            closingBraceIndentAdjusted = stamp != document.getModificationStamp();
            document.deleteString(caretOffset, caretOffset + 1);
        }
        closingBraceIndentAdjusted = stamp != document.getModificationStamp();
        document.deleteString(caretOffset, caretOffset + 1);
        if (!closingBraceIndentAdjusted) {
            char c2;
            int line = document.getLineNumber(rBracesInsertOffset);
            StringBuilder buffer = new StringBuilder();
            int start2 = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            CharSequence text2 = document.getCharsSequence();
            for (int i2 = start2; i2 < end && ((c2 = text2.charAt(i2)) == ' ' || c2 == '\t'); ++i2) {
                buffer.append(c2);
            }
            if (buffer.length() > 0) {
                document.insertString(rBracesInsertOffset + 1, (CharSequence)buffer);
            }
        }
    }

    protected Pair<PsiElement, Integer> calculateOffsetToInsertClosingBrace(@NotNull PsiFile file2, @NotNull CharSequence text2, int offset) {
        ASTNode parentNode;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "calculateOffsetToInsertClosingBrace"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/editorActions/enter/EnterAfterUnmatchedBraceHandler", "calculateOffsetToInsertClosingBrace"));
        }
        PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)offset);
        ASTNode node = element.getNode();
        if (node != null && node.getElementType() == TokenType.WHITE_SPACE) {
            return Pair.create(null, (Object)CharArrayUtil.shiftForwardUntil((CharSequence)text2, (int)offset, (String)"\n"));
        }
        for (PsiElement parent = element.getParent(); parent != null && (parentNode = parent.getNode()) != null && parentNode.getStartOffset() == offset; parent = parent.getParent()) {
            element = parent;
        }
        if (element.getTextOffset() != offset) {
            return Pair.create(null, (Object)CharArrayUtil.shiftForwardUntil((CharSequence)text2, (int)offset, (String)"\n"));
        }
        return Pair.create((Object)element, (Object)this.calculateOffsetToInsertClosingBraceInsideElement(element));
    }

    protected int calculateOffsetToInsertClosingBraceInsideElement(PsiElement element) {
        return element.getTextRange().getEndOffset();
    }

    public static boolean isAfterUnmatchedLBrace(Editor editor, int offset, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.getUnmatchedLBracesNumberBefore(editor, offset, fileType) > 0;
    }

    protected static int getUnmatchedLBracesNumberBefore(Editor editor, int offset, FileType fileType) {
        if (offset == 0) {
            return -1;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '{') {
            return -1;
        }
        EditorHighlighter highlighter2 = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator2 = highlighter2.createIterator(offset - 1);
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (!braceMatcher.isLBraceToken(iterator2, chars, fileType) || !braceMatcher.isStructuralBrace(iterator2, chars, fileType)) {
            return -1;
        }
        Language language = iterator2.getTokenType().getLanguage();
        iterator2 = highlighter2.createIterator(0);
        int lBracesBeforeOffset = 0;
        int lBracesAfterOffset = 0;
        int rBracesBeforeOffset = 0;
        int rBracesAfterOffset = 0;
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (tokenType.getLanguage().equals(language) && braceMatcher.isStructuralBrace(iterator2, chars, fileType)) {
                boolean beforeOffset;
                boolean bl = beforeOffset = iterator2.getStart() < offset;
                if (braceMatcher.isLBraceToken(iterator2, chars, fileType)) {
                    if (beforeOffset) {
                        ++lBracesBeforeOffset;
                    } else {
                        ++lBracesAfterOffset;
                    }
                } else if (braceMatcher.isRBraceToken(iterator2, chars, fileType)) {
                    if (beforeOffset) {
                        ++rBracesBeforeOffset;
                    } else {
                        ++rBracesAfterOffset;
                    }
                }
            }
            iterator2.advance();
        }
        return lBracesBeforeOffset - rBracesBeforeOffset - (rBracesAfterOffset - lBracesAfterOffset);
    }
}

