/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.xml.TagNameVariantCollector;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

class XmlMover
extends LineMover {
    XmlMover() {
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiNamedElement targetParent;
        PsiElement updatedElement;
        TextRange valueRange;
        PsiElement parent;
        PsiElement movedStartElement;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover", "checkAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover", "checkAvailable"));
        }
        if (!(file2 instanceof XmlFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        Document document = editor.getDocument();
        int movedLineStart = document.getLineStartOffset(info.toMove.startLine);
        int movedLineEnd = document.getLineEndOffset(info.toMove.endLine - 1);
        PsiElement movedEndElement = file2.findElementAt(movedLineEnd);
        if (movedEndElement instanceof PsiWhiteSpace) {
            movedEndElement = PsiTreeUtil.prevLeaf((PsiElement)movedEndElement);
        }
        if ((movedStartElement = file2.findElementAt(movedLineStart)) instanceof PsiWhiteSpace) {
            movedStartElement = PsiTreeUtil.nextLeaf((PsiElement)movedStartElement);
        }
        if (movedEndElement == null || movedStartElement == null) {
            return false;
        }
        PsiNamedElement namedParentAtEnd = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)movedEndElement, PsiNamedElement.class);
        PsiNamedElement namedParentAtStart = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)movedStartElement, PsiNamedElement.class);
        if (XmlMover.checkInjections(movedEndElement, movedStartElement)) {
            return false;
        }
        PsiNamedElement movedParent = null;
        if (namedParentAtEnd == namedParentAtStart) {
            movedParent = namedParentAtEnd;
        } else if (namedParentAtEnd instanceof XmlAttribute && namedParentAtStart instanceof XmlTag && namedParentAtEnd.getParent() == namedParentAtStart) {
            movedParent = namedParentAtStart;
        } else if (namedParentAtStart instanceof XmlAttribute && namedParentAtEnd instanceof XmlTag && namedParentAtStart.getParent() == namedParentAtEnd) {
            movedParent = namedParentAtEnd;
        }
        if (movedParent == null) {
            return false;
        }
        TextRange textRange = movedParent.getTextRange();
        if (movedParent instanceof XmlTag) {
            XmlTag tag = (XmlTag)movedParent;
            parent = tag.getParent();
            if (!(parent instanceof XmlTag) && ((XmlTag[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, XmlTag.class)).length < 2) {
                return info.prohibitMove();
            }
            valueRange = tag.getValue().getTextRange();
            int valueStart = valueRange.getStartOffset();
            if (HtmlUtil.isHtmlTag(tag) && (HtmlUtil.isScriptTag(tag) || "style".equals(tag.getName()))) {
                info.toMove = new LineRange((PsiElement)tag);
                int nextLine = down ? info.toMove.endLine : info.toMove.startLine - 1;
                info.toMove2 = new LineRange(nextLine, nextLine + 1);
            }
            if (movedLineStart < valueStart && valueStart + 1 < document.getTextLength()) {
                movedLineStart = XmlMover.updateMovedRegionEnd(document, movedLineStart, valueStart + 1, info, down);
            }
            if (movedLineStart < valueStart) {
                movedLineStart = XmlMover.updateMovedRegionStart(document, movedLineStart, tag.getTextRange().getStartOffset(), info, down);
            }
        } else if (movedParent instanceof XmlAttribute) {
            int endOffset = textRange.getEndOffset() + 1;
            if (endOffset < document.getTextLength()) {
                movedLineStart = XmlMover.updateMovedRegionEnd(document, movedLineStart, endOffset, info, down);
            }
            movedLineStart = XmlMover.updateMovedRegionStart(document, movedLineStart, textRange.getStartOffset(), info, down);
        }
        UnfairTextRange moveDestinationRange = new UnfairTextRange(document.getLineStartOffset(info.toMove2.startLine), document.getLineEndOffset(info.toMove2.endLine - 1));
        if (movedParent instanceof XmlAttribute && (parent = ((XmlAttribute)movedParent).getParent()) != null) {
            valueRange = parent.getValue().getTextRange();
            if (down && moveDestinationRange.getEndOffset() >= valueRange.getStartOffset() || !down && moveDestinationRange.getStartOffset() <= parent.getTextRange().getStartOffset()) {
                return info.prohibitMove();
            }
        }
        if (down) {
            updatedElement = file2.findElementAt(moveDestinationRange.getEndOffset());
            if (updatedElement instanceof PsiWhiteSpace) {
                updatedElement = PsiTreeUtil.prevLeaf((PsiElement)updatedElement);
            }
            if (updatedElement != null) {
                targetParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)updatedElement, movedParent.getClass());
                if (targetParent instanceof XmlTag) {
                    if (targetParent == movedParent) {
                        return false;
                    }
                    if (XmlMover.moveTags(info, (XmlTag)movedParent, (XmlTag)targetParent, down)) {
                        return true;
                    }
                    XmlTag tag = (XmlTag)targetParent;
                    int offset = tag.isEmpty() ? tag.getTextRange().getStartOffset() : tag.getValue().getTextRange().getStartOffset();
                    XmlMover.updatedMovedIntoEnd(document, info, offset);
                    if (tag.isEmpty()) {
                        info.toMove2 = new LineRange((PsiElement)targetParent);
                    }
                } else if (targetParent instanceof XmlAttribute) {
                    XmlMover.updatedMovedIntoEnd(document, info, targetParent.getTextRange().getEndOffset());
                }
            }
        } else {
            updatedElement = file2.findElementAt(moveDestinationRange.getStartOffset());
            if (updatedElement instanceof PsiWhiteSpace) {
                updatedElement = PsiTreeUtil.nextLeaf((PsiElement)updatedElement);
            }
            if (updatedElement != null) {
                targetParent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)updatedElement, movedParent.getClass());
                if (targetParent instanceof XmlTag) {
                    XmlTag tag = (XmlTag)targetParent;
                    TextRange tagValueRange = tag.getValue().getTextRange();
                    XmlTag[] subtags = tag.getSubTags();
                    if (tagValueRange.contains(movedLineStart) && subtags.length > 0 && subtags[0] == movedParent || tagValueRange.getLength() == 0 && tag.getTextRange().intersects((TextRange)moveDestinationRange)) {
                        int line = document.getLineNumber(tag.getTextRange().getStartOffset());
                        LineRange toMove2 = info.toMove2;
                        info.toMove2 = new LineRange(Math.min(line, toMove2.startLine), toMove2.endLine);
                    }
                    if (targetParent == movedParent) {
                        return false;
                    }
                    if (XmlMover.moveTags(info, (XmlTag)movedParent, (XmlTag)targetParent, down)) {
                        return true;
                    }
                } else if (targetParent instanceof XmlAttribute) {
                    int line = document.getLineNumber(targetParent.getTextRange().getStartOffset());
                    LineRange toMove2 = info.toMove2;
                    info.toMove2 = new LineRange(Math.min(line, toMove2.startLine), toMove2.endLine);
                }
            }
        }
        if (movedParent instanceof XmlTag) {
            info.toMove = new LineRange((PsiElement)movedParent);
        }
        return true;
    }

    private static boolean moveTags(StatementUpDownMover.MoveInfo info, XmlTag moved, XmlTag target, boolean down) {
        if (target.getParent() == moved) {
            XmlTag next;
            XmlTag xmlTag = next = down ? (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)moved, XmlTag.class) : (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)moved, XmlTag.class);
            if (next == null) {
                return info.prohibitMove();
            }
            info.toMove = new LineRange((PsiElement)moved);
            info.toMove2 = new LineRange((PsiElement)next);
            return true;
        }
        if (moved.getParent() == target) {
            return false;
        }
        LineRange targetRange = new LineRange((PsiElement)target);
        LineRange lineRange = targetRange = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(target.getNode()) == null ? new LineRange(targetRange.startLine, targetRange.endLine - 1) : targetRange;
        if (targetRange.contains(info.toMove2)) {
            XmlElementDescriptor descriptor2 = moved.getDescriptor();
            if (descriptor2 == null) {
                return false;
            }
            XmlNSDescriptor nsDescriptor = descriptor2.getNSDescriptor();
            if (nsDescriptor == null) {
                return false;
            }
            XmlFile descriptorFile = nsDescriptor.getDescriptorFile();
            if (descriptorFile == null || XmlDocumentImpl.isAutoGeneratedSchema(descriptorFile)) {
                return false;
            }
            if (!TagNameVariantCollector.couldContain(target, moved)) {
                info.toMove = new LineRange((PsiElement)moved);
                info.toMove2 = targetRange;
                return true;
            }
        }
        return false;
    }

    private static boolean checkInjections(PsiElement movedEndElement, PsiElement movedStartElement) {
        XmlText text2 = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)movedStartElement, XmlText.class);
        XmlText text22 = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)movedEndElement, XmlText.class);
        return text2 != null && InjectedLanguageManager.getInstance((Project)text2.getProject()).getInjectedPsiFiles((PsiElement)text2) != null || text22 != null && InjectedLanguageManager.getInstance((Project)text22.getProject()).getInjectedPsiFiles((PsiElement)text22) != null;
    }

    private static void updatedMovedIntoEnd(Document document, @NotNull StatementUpDownMover.MoveInfo info, int offset) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover", "updatedMovedIntoEnd"));
        }
        if (offset + 1 < document.getTextLength()) {
            int line = document.getLineNumber(offset + 1);
            LineRange toMove2 = info.toMove2;
            if (toMove2 == null) {
                return;
            }
            info.toMove2 = new LineRange(toMove2.startLine, Math.min(Math.max(line, toMove2.endLine), document.getLineCount() - 1));
        }
    }

    private static int updateMovedRegionStart(Document document, int movedLineStart, int offset, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover", "updateMovedRegionStart"));
        }
        int line = document.getLineNumber(offset);
        LineRange toMove = info.toMove;
        int delta = toMove.startLine - line;
        info.toMove = new LineRange(Math.min(line, toMove.startLine), toMove.endLine);
        if (delta > 0 && !down) {
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine - delta, toMove2.endLine - delta);
            movedLineStart = document.getLineStartOffset(toMove.startLine);
        }
        return movedLineStart;
    }

    private static int updateMovedRegionEnd(Document document, int movedLineStart, int valueStart, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/XmlMover", "updateMovedRegionEnd"));
        }
        int line = document.getLineNumber(valueStart);
        LineRange toMove = info.toMove;
        int delta = line - toMove.endLine;
        info.toMove = new LineRange(toMove.startLine, Math.max(line, toMove.endLine));
        if (delta > 0 && down) {
            LineRange toMove2 = info.toMove2;
            info.toMove2 = new LineRange(toMove2.startLine + delta, Math.min(toMove2.endLine + delta, document.getLineCount() - 1));
            movedLineStart = document.getLineStartOffset(toMove.startLine);
        }
        return movedLineStart;
    }
}

