/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;

public class BlockCommentSelectioner
implements ExtendWordSelectionHandler {
    public boolean canSelect(PsiElement e2) {
        return e2 instanceof PsiComment && !(e2 instanceof PsiDocCommentBase);
    }

    public List<TextRange> select(PsiElement e2, CharSequence editorText, int cursorOffset, Editor editor) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(e2.getLanguage());
        if (commenter == null) {
            return null;
        }
        String blockStart = commenter.getBlockCommentPrefix();
        String blockEnd = commenter.getBlockCommentSuffix();
        if (blockStart == null || blockEnd == null) {
            return null;
        }
        String elementText = e2.getText();
        if (elementText == null || !elementText.startsWith(blockStart) || !elementText.endsWith(blockEnd)) {
            return null;
        }
        TextRange elementRange = e2.getTextRange();
        return Collections.singletonList(new TextRange(elementRange.getStartOffset() + blockStart.length(), elementRange.getEndOffset() - blockEnd.length()));
    }
}

