/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.WordSelectioner;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;

public class LineCommentSelectioner
extends WordSelectioner {
    @Override
    public boolean canSelect(PsiElement e2) {
        if (e2 instanceof PsiComment) {
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(e2.getLanguage());
            if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
                return true;
            }
            return !((CodeDocumentationAwareCommenter)commenter).isDocumentationComment((PsiComment)e2);
        }
        return false;
    }

    @Override
    public List<TextRange> select(PsiElement element, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result2 = super.select(element, editorText, cursorOffset, editor);
        PsiElement firstComment = element;
        PsiElement e2 = element;
        while (e2.getPrevSibling() != null) {
            if (e2 instanceof PsiComment) {
                firstComment = e2;
            } else if (!(e2 instanceof PsiWhiteSpace)) break;
            e2 = e2.getPrevSibling();
        }
        PsiElement lastComment = element;
        e2 = element;
        while (e2.getNextSibling() != null) {
            if (e2 instanceof PsiComment) {
                lastComment = e2;
            } else if (!(e2 instanceof PsiWhiteSpace)) break;
            e2 = e2.getNextSibling();
        }
        result2.addAll(LineCommentSelectioner.expandToWholeLine(editorText, new TextRange(firstComment.getTextRange().getStartOffset(), lastComment.getTextRange().getEndOffset())));
        return result2;
    }
}

