/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class NaturalLanguageTextSelectioner
extends ExtendWordSelectionHandlerBase {
    private static final Set<Character> NATURAL = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('$'), Character.valueOf('@'), Character.valueOf('%'), Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('_')});
    private static final Set<Character> SENTENCE_END = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?')});

    @Override
    public boolean canSelect(PsiElement e2) {
        return (e2 instanceof PsiPlainText || e2 instanceof PsiComment) && !(e2.getContainingFile().getFileType() instanceof CustomSyntaxTableFileType);
    }

    private static TextRange findParagraphRange(String text2, int start2, int end) {
        int paragraphEnd;
        int paragraphStart = text2.lastIndexOf("\n\n", start2);
        if (paragraphStart >= (paragraphEnd = text2.indexOf("\n\n", end))) {
            return new TextRange(0, text2.length());
        }
        return new TextRange(paragraphStart >= 0 ? paragraphStart + 2 : 0, paragraphEnd < 0 ? text2.length() : paragraphEnd);
    }

    @Nullable
    private static TextRange findCustomRange(String text2, int start2, int end, char startChar, char endChar) {
        int prev = text2.lastIndexOf(startChar, start2);
        int next = text2.indexOf(endChar, end);
        if (prev < 0 || next < 0) {
            return null;
        }
        if (prev + 1 < start2 || next > end) {
            return new TextRange(prev + 1, next);
        }
        return new TextRange(prev, next + 1);
    }

    @Nullable
    private static TextRange findSentenceRange(String editorText, int start2, int end) {
        int sentenceStart;
        for (sentenceStart = start2; sentenceStart > 0; --sentenceStart) {
            if (start2 - sentenceStart > 1000) {
                return null;
            }
            if (NaturalLanguageTextSelectioner.isSentenceEnd(editorText, sentenceStart - 1) || !NaturalLanguageTextSelectioner.isNatural(editorText.charAt(sentenceStart - 1))) break;
        }
        while (sentenceStart < end && Character.isWhitespace(editorText.charAt(sentenceStart))) {
            ++sentenceStart;
        }
        int sentenceEnd = Math.max(0, end - 1);
        while (sentenceEnd < editorText.length()) {
            if (++sentenceEnd - end > 1000) {
                return null;
            }
            if (!NaturalLanguageTextSelectioner.isSentenceEnd(editorText, sentenceEnd - 1)) continue;
        }
        return new TextRange(sentenceStart, sentenceEnd);
    }

    private static boolean isSentenceEnd(String text2, int i2) {
        return SENTENCE_END.contains(Character.valueOf(text2.charAt(i2))) && (i2 + 1 == text2.length() || Character.isWhitespace(text2.charAt(i2 + 1)));
    }

    private static TextRange findNaturalRange(String editorText, int start2, int end) {
        char c2;
        while (start2 > 0 && NaturalLanguageTextSelectioner.isNatural(editorText.charAt(start2 - 1))) {
            --start2;
        }
        while (end < editorText.length() && NaturalLanguageTextSelectioner.isNatural(c2 = editorText.charAt(end))) {
            ++end;
        }
        return new TextRange(start2, end);
    }

    @Override
    public List<TextRange> select(PsiElement e2, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        NaturalLanguageTextSelectioner.addWordRange(editorText, cursorOffset, result2);
        TextRange range = NaturalLanguageTextSelectioner.expandSelection(e2, editorText, cursorOffset, cursorOffset);
        if (range != null) {
            TextRange next;
            result2.add(range);
            while ((next = NaturalLanguageTextSelectioner.expandSelection(e2, editorText, range.getStartOffset(), range.getEndOffset())) != null && !range.contains(next)) {
                result2.add(next);
                range = next;
            }
        }
        return result2;
    }

    private static void addWordRange(CharSequence editorText, int cursorOffset, ArrayList<TextRange> result2) {
        SelectWordUtil.addWordSelection(false, editorText, cursorOffset, result2, ch -> Character.isJavaIdentifierPart(ch) || ch == '\'');
        SelectWordUtil.addWordSelection(false, editorText, cursorOffset, result2, ch -> Character.isJavaIdentifierPart(ch) || ch == '\'' || ch == '-');
    }

    @Nullable
    private static TextRange expandSelection(PsiElement e2, CharSequence editorText, int selStart, int selEnd) {
        int end;
        int start2;
        TextRange range = e2.getTextRange();
        int shift = range.getStartOffset();
        if (selStart <= shift || selEnd >= range.getEndOffset()) {
            return null;
        }
        String elementText = editorText.subSequence(shift, range.getEndOffset()).toString();
        TextRange best = NaturalLanguageTextSelectioner.findSentenceRange(elementText, start2 = selStart - shift, end = selEnd - shift);
        if (best == null) {
            return null;
        }
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '\"', '\"'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '(', ')'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '<', '>'));
        best = NaturalLanguageTextSelectioner.narrowRange(best, NaturalLanguageTextSelectioner.findCustomRange(elementText, start2, end, '[', ']'));
        TextRange natural = NaturalLanguageTextSelectioner.findNaturalRange(elementText, start2, end);
        if (!natural.contains(best)) {
            return null;
        }
        TextRange paragraph = NaturalLanguageTextSelectioner.findParagraphRange(elementText, start2, end);
        if (best.getStartOffset() == start2 && best.getEndOffset() == end || !paragraph.contains(best)) {
            return paragraph.shiftRight(shift);
        }
        return best.shiftRight(shift);
    }

    private static TextRange narrowRange(TextRange best, TextRange candidate) {
        return candidate != null && best.contains(candidate) ? candidate : best;
    }

    private static boolean isNatural(char c2) {
        return Character.isWhitespace(c2) || Character.isLetterOrDigit(c2) || NATURAL.contains(Character.valueOf(c2));
    }
}

