/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.lang.CodeInsightActions;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class OverrideMethodsHandler
implements CodeInsightActionHandler {
    public final void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/OverrideMethodsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/OverrideMethodsHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/OverrideMethodsHandler", "invoke"));
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project2)) {
            return;
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        LanguageCodeInsightActionHandler codeInsightActionHandler = (LanguageCodeInsightActionHandler)CodeInsightActions.OVERRIDE_METHOD.forLanguage(language);
        if (codeInsightActionHandler != null) {
            codeInsightActionHandler.invoke(project2, editor, file2);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

