/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.util.Map;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        HighlightManagerImpl highlightManager;
        editor.setHeaderComponent(null);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && (highlightManager = (HighlightManagerImpl)HighlightManager.getInstance((Project)project2)) != null && highlightManager.hideHighlights(editor, 3)) {
            FindModel model2;
            FindManager findManager;
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            if (statusBar != null) {
                statusBar.setInfo("");
            }
            if ((findManager = FindManager.getInstance((Project)project2)) != null && (model2 = findManager.getFindNextModel(editor)) != null) {
                model2.setSearchHighlighters(false);
                findManager.setFindNextModel(model2);
            }
            return;
        }
        this.myOriginalHandler.execute(editor, dataContext);
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        Map<RangeHighlighter, HighlightManagerImpl.HighlightInfo> map2;
        HighlightManagerImpl highlightManager;
        if (editor.hasHeaderComponent()) {
            return true;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && (highlightManager = (HighlightManagerImpl)HighlightManager.getInstance((Project)project2)) != null && (map2 = highlightManager.getHighlightInfoMap(editor, false)) != null) {
            for (HighlightManagerImpl.HighlightInfo info : map2.values()) {
                if (!info.editor.equals(editor) || (info.flags & 1) == 0) continue;
                return true;
            }
        }
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }
}

