/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DocumentFragmentTooltipRenderer
implements TooltipRenderer {
    private final DocumentFragment myDocumentFragment;

    public DocumentFragmentTooltipRenderer(DocumentFragment documentFragment) {
        this.myDocumentFragment = documentFragment;
    }

    @Override
    public LightweightHint show(@NotNull Editor editor, @NotNull Point p2, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint intInfo) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/DocumentFragmentTooltipRenderer", "show"));
        }
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/DocumentFragmentTooltipRenderer", "show"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/DocumentFragmentTooltipRenderer", "show"));
        }
        if (intInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intInfo", "com/intellij/codeInsight/hint/DocumentFragmentTooltipRenderer", "show"));
        }
        JComponent editorComponent = editor.getComponent();
        TextRange range = this.myDocumentFragment.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        Document doc = this.myDocumentFragment.getDocument();
        int endLine = doc.getLineNumber(endOffset);
        int startLine = doc.getLineNumber(startOffset);
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        VisualPosition visual = editor.offsetToVisualPosition(startOffset);
        p2 = editor.visualPositionToXY(visual);
        p2 = SwingUtilities.convertPoint(((EditorEx)editor).getGutterComponentEx(), p2, layeredPane);
        p2.x -= 3;
        p2.y += editor.getLineHeight();
        Point screenPoint = new Point(p2);
        SwingUtilities.convertPointToScreen(screenPoint, layeredPane);
        int maxLineCount = (ScreenUtil.getScreenRectangle((Point)screenPoint).height - screenPoint.y) / editor.getLineHeight();
        if (endLine - startLine > maxLineCount) {
            endOffset = doc.getLineEndOffset(Math.max(0, Math.min(startLine + maxLineCount, doc.getLineCount() - 1)));
        }
        if (endOffset < startOffset) {
            return null;
        }
        FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
        foldingModel.setFoldingEnabled(false);
        TextRange textRange = new TextRange(startOffset, endOffset);
        LightweightHint hint = EditorFragmentComponent.showEditorFragmentHintAt(editor, textRange, p2.y, false, false, true, true, true);
        foldingModel.setFoldingEnabled(true);
        return hint;
    }
}

