/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    private final boolean myRequestFocus;

    public ShowParameterInfoHandler() {
        this(false);
    }

    public ShowParameterInfoHandler(boolean requestFocus2) {
        this.myRequestFocus = requestFocus2;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "invoke"));
        }
        ShowParameterInfoHandler.invoke(project2, editor, file2, -1, null, this.myRequestFocus);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiElement findAnyElementAt(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hint/ShowParameterInfoHandler", "findAnyElementAt"));
        }
        PsiElement element = file2.findElementAt(offset);
        if (element == null && offset > 0) {
            element = file2.findElementAt(offset - 1);
        }
        return element;
    }

    public static void invoke(Project project2, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement) {
        ShowParameterInfoHandler.invoke(project2, editor, file2, lbraceOffset, highlightedElement, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(Project project2, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus2) {
        LookupEx lookup;
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = ShowParameterInfoHandler.findAnyElementAt(file2, offset);
        if (psiElement == null) {
            return;
        }
        ShowParameterInfoContext context2 = new ShowParameterInfoContext(editor, project2, file2, offset, lbraceOffset, requestFocus2);
        context2.setHighlightedElement(highlightedElement);
        context2.setRequestFocus(requestFocus2);
        Language language = psiElement.getLanguage();
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(project2, language, file2.getViewProvider().getBaseLanguage());
        if (handlers == null) {
            handlers = new ParameterInfoHandler[]{};
        }
        if ((lookup = LookupManager.getInstance(project2).getActiveLookup()) != null) {
            LookupElement item = lookup.getCurrentItem();
            if (item != null) {
                for (ParameterInfoHandler handler2 : handlers) {
                    if (!handler2.couldShowInLookup()) continue;
                    Object[] items2 = handler2.getParametersForLookup(item, (ParameterInfoContext)context2);
                    if (items2 != null && items2.length > 0) {
                        ShowParameterInfoHandler.showLookupEditorHint(items2, editor, project2, handler2, requestFocus2);
                    }
                    return;
                }
            }
            return;
        }
        DumbService.getInstance((Project)project2).setAlternativeResolveEnabled(true);
        try {
            for (ParameterInfoHandler handler3 : handlers) {
                Object element = handler3.findElementForParameterInfo((CreateParameterInfoContext)context2);
                if (element == null) continue;
                handler3.showParameterInfo(element, (CreateParameterInfoContext)context2);
            }
        }
        finally {
            DumbService.getInstance((Project)project2).setAlternativeResolveEnabled(false);
        }
    }

    private static void showLookupEditorHint(Object[] descriptors, Editor editor, Project project2, ParameterInfoHandler handler2, boolean requestFocus2) {
        ParameterInfoComponent component = new ParameterInfoComponent(descriptors, editor, handler2, requestFocus2);
        component.update();
        LightweightHint hint = new LightweightHint(component);
        hint.setSelectingHint(true);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Pair<Point, Short> pos = ShowParameterInfoContext.chooseBestHintPosition(project2, editor, -1, -1, hint, true, (short)6);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!editor.getComponent().isShowing()) {
                return;
            }
            hintManager.showEditorHint(hint, editor, (Point)pos.getFirst(), 134, 0, false, (Short)pos.getSecond());
        });
    }

    @Nullable
    public static ParameterInfoHandler[] getHandlers(Project project2, Language ... languages) {
        THashSet handlers = new THashSet();
        for (Language language : languages) {
            handlers.addAll(DumbService.getInstance((Project)project2).filterByDumbAwareness((Collection)LanguageParameterInfo.INSTANCE.allForLanguage(language)));
        }
        if (handlers.isEmpty()) {
            return null;
        }
        return handlers.toArray(new ParameterInfoHandler[handlers.size()]);
    }

    static interface BestLocationPointProvider {
        @NotNull
        public Pair<Point, Short> getBestPointPosition(LightweightHint var1, PsiElement var2, int var3, boolean var4, short var5);
    }
}

