/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class ShowParameterInfoAction
extends BaseCodeInsightAction
implements DumbAware {
    private boolean myRequestFocus = false;

    public ShowParameterInfoAction() {
        this.setEnabledInModalContext(true);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/actions/ShowParameterInfoAction", "beforeActionPerformedUpdate"));
        }
        super.beforeActionPerformedUpdate(e2);
        this.myRequestFocus = ScreenReader.isActive() && e2.getInputEvent() instanceof KeyEvent;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        ShowParameterInfoHandler showParameterInfoHandler = new ShowParameterInfoHandler(this.myRequestFocus);
        if (showParameterInfoHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/actions/ShowParameterInfoAction", "getHandler"));
        }
        return showParameterInfoHandler;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/hint/actions/ShowParameterInfoAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/actions/ShowParameterInfoAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hint/actions/ShowParameterInfoAction", "isValidForFile"));
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        return ShowParameterInfoHandler.getHandlers(project2, language, file2.getViewProvider().getBaseLanguage()) != null;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }
}

