/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParameterInfoHandler
implements ParameterInfoHandler<XmlTag, XmlElementDescriptor> {
    private static final Comparator<XmlAttributeDescriptor> COMPARATOR = Comparator.comparing(PsiMetaData::getName);

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context2) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object lookupItem = item.getObject();
        if (lookupItem instanceof XmlElementDescriptor) {
            return new Object[]{lookupItem};
        }
        return null;
    }

    public Object[] getParametersForDocumentation(XmlElementDescriptor p2, ParameterInfoContext context2) {
        return XmlParameterInfoHandler.getSortedDescriptors(p2);
    }

    public static XmlAttributeDescriptor[] getSortedDescriptors(XmlElementDescriptor p2) {
        XmlAttributeDescriptor[] xmlAttributeDescriptors = p2.getAttributesDescriptors(null);
        Arrays.sort(xmlAttributeDescriptors, COMPARATOR);
        return xmlAttributeDescriptors;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    public XmlTag findElementForParameterInfo(@NotNull CreateParameterInfoContext context2) {
        XmlElementDescriptor descriptor2;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "findElementForParameterInfo"));
        }
        XmlTag tag = XmlParameterInfoHandler.findXmlTag(context2.getFile(), context2.getOffset());
        XmlElementDescriptor xmlElementDescriptor = descriptor2 = tag != null ? tag.getDescriptor() : null;
        if (descriptor2 == null) {
            DaemonCodeAnalyzer.getInstance((Project)context2.getProject()).updateVisibleHighlighters(context2.getEditor());
            return null;
        }
        context2.setItemsToShow(new Object[]{descriptor2});
        return tag;
    }

    public void showParameterInfo(@NotNull XmlTag element, @NotNull CreateParameterInfoContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "showParameterInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "showParameterInfo"));
        }
        context2.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public XmlTag findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context2) {
        PsiElement currentXmlTag;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        XmlTag tag = XmlParameterInfoHandler.findXmlTag(context2.getFile(), context2.getOffset());
        if (tag != null && ((currentXmlTag = context2.getParameterOwner()) == null || currentXmlTag == tag)) {
            return tag;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull XmlTag parameterOwner, @NotNull UpdateParameterInfoContext context2) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "updateParameterInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "updateParameterInfo"));
        }
        if (context2.getParameterOwner() == null || parameterOwner.equals(context2.getParameterOwner())) {
            context2.setParameterOwner((PsiElement)parameterOwner);
        } else {
            context2.removeHint();
        }
    }

    public String getParameterCloseChars() {
        return null;
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    @Nullable
    private static XmlTag findXmlTag(PsiFile file2, int offset) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (!(element instanceof XmlTag)) continue;
            XmlTag tag = (XmlTag)element;
            PsiElement[] children2 = tag.getChildren();
            if (offset <= children2[0].getTextRange().getStartOffset()) {
                return null;
            }
            for (PsiElement child : children2) {
                XmlToken token;
                TextRange range = child.getTextRange();
                if (range.getStartOffset() <= offset && range.getEndOffset() > offset) {
                    return tag;
                }
                if (!(child instanceof XmlToken) || (token = (XmlToken)child).getTokenType() != XmlTokenType.XML_TAG_END) continue;
                return null;
            }
            return null;
        }
        return null;
    }

    public void updateUI(XmlElementDescriptor o2, final @NotNull ParameterInfoUIContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler", "updateUI"));
        }
        XmlParameterInfoHandler.updateElementDescriptor(o2, context2, new Function<String, Boolean>(){
            final XmlTag parameterOwner;
            {
                this.parameterOwner = (XmlTag)context2.getParameterOwner();
            }

            public Boolean fun(String s2) {
                return this.parameterOwner != null && this.parameterOwner.getAttributeValue(s2) != null;
            }
        });
    }

    public static void updateElementDescriptor(XmlElementDescriptor descriptor2, ParameterInfoUIContext context2, Function<String, Boolean> attributePresentFun) {
        XmlAttributeDescriptor[] attributes = descriptor2 != null ? XmlParameterInfoHandler.getSortedDescriptors(descriptor2) : XmlAttributeDescriptor.EMPTY;
        StringBuilder buffer = new StringBuilder();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (attributes.length == 0) {
            buffer.append(CodeInsightBundle.message((String)"xml.tag.info.no.attributes", (Object[])new Object[0]));
        } else {
            StringBuilder text1 = new StringBuilder(" ");
            StringBuilder text2 = new StringBuilder(" ");
            StringBuilder text3 = new StringBuilder(" ");
            for (XmlAttributeDescriptor attribute : attributes) {
                if (Boolean.TRUE.equals(attributePresentFun.fun((Object)attribute.getName()))) {
                    if (!text1.toString().equals(" ")) {
                        text1.append(", ");
                    }
                    text1.append(attribute.getName());
                    continue;
                }
                if (attribute.isRequired()) {
                    if (!text2.toString().equals(" ")) {
                        text2.append(", ");
                    }
                    text2.append(attribute.getName());
                    continue;
                }
                if (!text3.toString().equals(" ")) {
                    text3.append(", ");
                }
                text3.append(attribute.getName());
            }
            if (!text1.toString().equals(" ") && !text2.toString().equals(" ")) {
                text1.append(", ");
            }
            if (!text2.toString().equals(" ") && !text3.toString().equals(" ")) {
                text2.append(", ");
            }
            if (!text1.toString().equals(" ") && !text3.toString().equals(" ") && text2.toString().equals(" ")) {
                text1.append(", ");
            }
            buffer.append((CharSequence)text1);
            highlightStartOffset = buffer.length();
            buffer.append((CharSequence)text2);
            highlightEndOffset = buffer.length();
            buffer.append((CharSequence)text3);
        }
        context2.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, false, true, context2.getDefaultParameterColor());
    }
}

