/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameHintsConfigurable
extends DialogWrapper {
    private JPanel myConfigurable;
    private ComboBox<Language> myCurrentLanguageCombo;
    private Map<Language, EditorTextField> myEditors;
    private Map<Language, Boolean> myIsValidPatterns;
    private Map<Option, JBCheckBox> myOptions;
    private JPanel myPanel;
    private CardLayout myCardLayout;

    public ParameterNameHintsConfigurable() {
        this(null, null);
    }

    public ParameterNameHintsConfigurable(@Nullable Language selectedLanguage, @Nullable String newPreselectedPattern) {
        super(null);
        this.$$$setupUI$$$();
        this.setTitle("Configure Parameter Name Hints");
        this.init();
        if (selectedLanguage != null) {
            this.showLanguagePanel(selectedLanguage);
            this.myCurrentLanguageCombo.setSelectedItem((Object)selectedLanguage);
            if (newPreselectedPattern != null) {
                this.addSelectedText(selectedLanguage, newPreselectedPattern);
            }
        }
    }

    private void addSelectedText(@NotNull Language language, @NotNull String newPreselectedPattern) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "addSelectedText"));
        }
        if (newPreselectedPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPreselectedPattern", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "addSelectedText"));
        }
        EditorTextField textField = this.myEditors.get(language);
        String text2 = textField.getText();
        int startOffset = text2.length();
        text2 = text2 + "\n" + newPreselectedPattern;
        int endOffset = text2.length();
        textField.setText(text2);
        textField.addSettingsProvider(editor -> {
            SelectionModel model2 = editor.getSelectionModel();
            model2.setSelection(startOffset + 1, endOffset);
        });
    }

    private void updateOkEnabled(@NotNull Language language, @NotNull EditorTextField editorTextField) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "updateOkEnabled"));
        }
        if (editorTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTextField", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "updateOkEnabled"));
        }
        String text2 = editorTextField.getText();
        List<Integer> invalidLines = HintUtilsKt.getBlackListInvalidLineNumbers(text2);
        this.myIsValidPatterns.put(language, invalidLines.isEmpty());
        boolean isEveryOneValid = !this.myIsValidPatterns.containsValue(false);
        this.getOKAction().setEnabled(isEveryOneValid);
        ParameterNameHintsConfigurable.highlightErrorLines(invalidLines, editorTextField);
    }

    private static void highlightErrorLines(@NotNull List<Integer> lines, @NotNull EditorTextField editorTextField) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "highlightErrorLines"));
        }
        if (editorTextField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTextField", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "highlightErrorLines"));
        }
        Editor editor = editorTextField.getEditor();
        if (editor == null) {
            return;
        }
        TextAttributes attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES);
        Document document = editor.getDocument();
        int totalLines = document.getLineCount();
        MarkupModel model2 = editor.getMarkupModel();
        model2.removeAllHighlighters();
        lines.stream().filter(current -> current < totalLines).forEach(line -> model2.addLineHighlighter(line.intValue(), 5000, attributes));
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myEditors.forEach((language, editor) -> {
            String blacklist = editor.getText();
            ParameterNameHintsConfigurable.storeBlackListDiff(language, blacklist);
        });
        this.myOptions.forEach((option, checkBox2) -> option.set(checkBox2.isSelected()));
    }

    private static void storeBlackListDiff(@NotNull Language language, @NotNull String text2) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "storeBlackListDiff"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "storeBlackListDiff"));
        }
        Set updatedBlackList = StringUtil.split((String)text2, (String)"\n").stream().filter(e2 -> !e2.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set defaultBlackList = provider.getDefaultBlackList();
        Diff diff = Diff.Builder.build(defaultBlackList, updatedBlackList);
        ParameterNameHintsSettings.getInstance().setBlackListDiff(language, diff);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myConfigurable;
    }

    private void createUIComponents() {
        this.myOptions = ContainerUtil.newHashMap();
        this.myEditors = ContainerUtil.newHashMap();
        this.myIsValidPatterns = ContainerUtil.newHashMap();
        List<Language> allLanguages = ParameterNameHintsConfigurable.getBaseLanguagesWithProviders();
        Language selected = allLanguages.get(0);
        this.initLanguageCombo(selected, allLanguages);
        this.myCardLayout = new CardLayout();
        this.myPanel = new JPanel(this.myCardLayout);
        allLanguages.forEach(language -> {
            JPanel panel2 = this.createLanguagePanel((Language)language);
            this.myPanel.add((Component)panel2, language.getDisplayName());
        });
        this.myCardLayout.show(this.myPanel, selected.getDisplayName());
    }

    @NotNull
    private JPanel createLanguagePanel(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createLanguagePanel"));
        }
        JPanel blacklistPanel = this.createBlacklistPanel(language);
        JPanel optionsPanel = this.createOptionsPanel(language);
        JPanel panel2 = new JPanel();
        BoxLayout layout = new BoxLayout(panel2, 1);
        panel2.setLayout(layout);
        if (blacklistPanel != null) {
            panel2.add(blacklistPanel);
        }
        if (optionsPanel != null) {
            panel2.add(optionsPanel);
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createLanguagePanel"));
        }
        return jPanel;
    }

    @Nullable
    private JPanel createBlacklistPanel(final @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createBlacklistPanel"));
        }
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (!provider.isBlackListSupported()) {
            return null;
        }
        String blackList = ParameterNameHintsConfigurable.getLanguageBlackList(language);
        final EditorTextField editorTextField = ParameterNameHintsConfigurable.createEditorField(blackList);
        editorTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e2) {
                ParameterNameHintsConfigurable.this.updateOkEnabled(language, editorTextField);
            }
        });
        this.updateOkEnabled(language, editorTextField);
        this.myEditors.put(language, editorTextField);
        JPanel blacklistPanel = new JPanel();
        BoxLayout layout = new BoxLayout(blacklistPanel, 1);
        blacklistPanel.setLayout(layout);
        blacklistPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Blacklist"));
        blacklistPanel.add((Component)new JBLabel(this.getBlacklistExplanationHTML(language)));
        blacklistPanel.add((Component)((Object)editorTextField));
        return blacklistPanel;
    }

    @NotNull
    private String getBlacklistExplanationHTML(Language language) {
        InlayParameterHintsProvider hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (hintsProvider == null) {
            String string2 = CodeInsightBundle.message((String)"inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getBlacklistExplanationHTML"));
            }
            return string2;
        }
        String string3 = hintsProvider.getBlacklistExplanationHTML();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getBlacklistExplanationHTML"));
        }
        return string3;
    }

    @Nullable
    private JPanel createOptionsPanel(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createOptionsPanel"));
        }
        List<Option> options = ParameterNameHintsConfigurable.getOptions(language);
        if (options.isEmpty()) {
            return null;
        }
        JPanel languageOptionsPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(languageOptionsPanel, 1);
        languageOptionsPanel.setLayout(boxLayout);
        if (!options.isEmpty()) {
            languageOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Options"));
        }
        for (Option option : options) {
            JBCheckBox box = new JBCheckBox(option.getName(), option.get());
            this.myOptions.put(option, box);
            languageOptionsPanel.add((Component)box);
        }
        return languageOptionsPanel;
    }

    private void initLanguageCombo(Language selected, List<Language> languages) {
        ListComboBoxModel model2 = new ListComboBoxModel(languages);
        this.myCurrentLanguageCombo = new ComboBox((ComboBoxModel)model2);
        this.myCurrentLanguageCombo.setSelectedItem((Object)selected);
        this.myCurrentLanguageCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Language>(){

            public void customize(JList list2, Language value2, int index, boolean selected, boolean hasFocus) {
                this.setText(value2.getDisplayName());
            }
        });
        this.myCurrentLanguageCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                Language language = (Language)e2.getItem();
                if (e2.getStateChange() == 1) {
                    ParameterNameHintsConfigurable.this.showLanguagePanel(language);
                }
            }
        });
    }

    private void showLanguagePanel(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "showLanguagePanel"));
        }
        this.myCardLayout.show(this.myPanel, language.getDisplayName());
    }

    private static List<Option> getOptions(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider != null) {
            return provider.getSupportedOptions();
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    private static String getLanguageBlackList(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getLanguageBlackList"));
        }
        InlayParameterHintsProvider hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (hintsProvider == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getLanguageBlackList"));
            }
            return "";
        }
        Diff diff = ParameterNameHintsSettings.getInstance().getBlackListDiff(language);
        Set blackList = diff.applyOn(hintsProvider.getDefaultBlackList());
        String string2 = StringUtil.join((Collection)blackList, (String)"\n");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getLanguageBlackList"));
        }
        return string2;
    }

    @NotNull
    private static List<Language> getBaseLanguagesWithProviders() {
        List<Language> list2 = HintUtilsKt.getHintProviders().stream().map(langWithImplementation -> (Language)langWithImplementation.getFirst()).sorted(Comparator.comparingInt(l2 -> l2.getDisplayName().length())).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getBaseLanguagesWithProviders"));
        }
        return list2;
    }

    @NotNull
    private static EditorTextField createEditorField(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createEditorField"));
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        EditorTextField field = new EditorTextField(document, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(200, 350));
        field.addSettingsProvider(editor -> {
            editor.setVerticalScrollbarVisible(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
        });
        EditorTextField editorTextField = field;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createEditorField"));
        }
        return editorTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myConfigurable = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.myPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboBox<Language> comboBox = this.myCurrentLanguageCombo;
        jPanel4.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Language:");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigurable;
    }
}

