/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching");
    private final List<IntentionAction> myOptionIntentions;
    private final List<IntentionAction> myOptionErrorFixes;
    private final List<IntentionAction> myOptionInspectionFixes;
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this(action2, action2.getText(), null);
    }

    IntentionActionWithTextCaching(@NotNull HighlightInfo.IntentionActionDescriptor action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this(action2.getAction(), action2.getDisplayName(), action2.getIcon());
    }

    private IntentionActionWithTextCaching(@NotNull IntentionAction action2, String displayName, @Nullable Icon icon) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "<init>"));
        }
        this.myOptionIntentions = new ArrayList<IntentionAction>();
        this.myOptionErrorFixes = new ArrayList<IntentionAction>();
        this.myOptionInspectionFixes = new ArrayList<IntentionAction>();
        this.myIcon = icon;
        this.myText = action2.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action2.getClass() + " text returned null"));
        this.myAction = action2;
        this.myDisplayName = displayName;
    }

    @NotNull
    String getText() {
        String string2 = this.myText;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getText"));
        }
        return string2;
    }

    void addIntention(@NotNull IntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addIntention"));
        }
        this.myOptionIntentions.add(action2);
    }

    void addErrorFix(@NotNull IntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addErrorFix"));
        }
        this.myOptionErrorFixes.add(action2);
    }

    void addInspectionFix(@NotNull IntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "addInspectionFix"));
        }
        this.myOptionInspectionFixes.add(action2);
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getAction"));
        }
        return intentionAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        List<IntentionAction> list2 = this.myOptionIntentions;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionIntentions"));
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        List<IntentionAction> list2 = this.myOptionErrorFixes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionErrorFixes"));
        }
        return list2;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        List<IntentionAction> list2 = this.myOptionInspectionFixes;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "getOptionInspectionFixes"));
        }
        return list2;
    }

    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        String string2 = this.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "toString"));
        }
        return string2;
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "compareTo"));
        }
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return ((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
    }
}

