/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        LookupEx lookup;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        if ((lookup = LookupManager.getActiveLookup(editor)) != null) {
            lookup.showElementActions();
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        ShowIntentionActionsHandler.letAutoImportComplete(editor, file2, codeAnalyzer);
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file2, intentions, -1);
        IntentionHintComponent hintComponent = codeAnalyzer.getLastIntentionHint();
        if (hintComponent != null) {
            IntentionHintComponent.PopupUpdateResult result2;
            IntentionHintComponent.PopupUpdateResult popupUpdateResult = result2 = hintComponent.isForEditor(editor) ? hintComponent.updateActions(intentions) : IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE;
            if (result2 == IntentionHintComponent.PopupUpdateResult.HIDE_AND_RECREATE) {
                hintComponent.hide();
            }
        }
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        this.showIntentionHint(project2, editor, file2, intentions);
    }

    protected void showIntentionHint(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "showIntentionHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "showIntentionHint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "showIntentionHint"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "showIntentionHint"));
        }
        if (!intentions.isEmpty()) {
            IntentionHintComponent.showIntentionHint(project2, file2, editor, intentions, true);
        }
    }

    private static void letAutoImportComplete(@NotNull Editor editor, @NotNull PsiFile file2, DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "letAutoImportComplete"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "letAutoImportComplete"));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$letAutoImportComplete$0"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$letAutoImportComplete$0"));
            }
            codeAnalyzer.autoImportReferenceAtCursor(editor, file2);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull IntentionAction action2) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (!psiFile.isValid()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = psiFile.findElementAt(offset);
        boolean inProject = psiFile.getManager().isInProject((PsiElement)psiFile);
        try {
            Project project2 = psiFile.getProject();
            if (action2 instanceof SuppressIntentionActionFromFix) {
                ThreeState shouldBeAppliedToInjectionHost = ((SuppressIntentionActionFromFix)action2).isShouldBeAppliedToInjectionHost();
                if (editor instanceof EditorWindow && shouldBeAppliedToInjectionHost == ThreeState.YES) {
                    return false;
                }
                if (!(editor instanceof EditorWindow) && shouldBeAppliedToInjectionHost == ThreeState.NO) {
                    return false;
                }
            }
            if (action2 instanceof PsiElementBaseIntentionAction ? !inProject || psiElement == null || !((PsiElementBaseIntentionAction)action2).isAvailable(project2, editor, psiElement) : !action2.isAvailable(project2, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e2) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull PairProcessor<PsiFile, Editor> predicate) {
        Editor injectedEditor;
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        Editor editorToApply = null;
        PsiFile fileToApply = null;
        int offset = hostEditor.getCaretModel().getOffset();
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, offset);
        if (injectedFile != null && predicate.process((Object)injectedFile, (Object)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
            editorToApply = injectedEditor;
            fileToApply = injectedFile;
        }
        if (editorToApply == null && predicate.process((Object)hostFile, (Object)hostEditor)) {
            editorToApply = hostEditor;
            fileToApply = hostFile;
        }
        if (editorToApply == null) {
            return null;
        }
        return Pair.create(fileToApply, editorToApply);
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull IntentionAction action2, @NotNull String text2) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        Project project2 = hostFile.getProject();
        return ShowIntentionActionsHandler.chooseActionAndInvoke(hostFile, hostEditor, action2, text2, project2);
    }

    static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2, @NotNull String text2, @NotNull Project project2) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickFix");
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(hostFile, hostEditor, action2);
        if (pair == null) {
            return false;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$chooseActionAndInvoke$2"));
            }
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$null$1"));
                }
                ShowIntentionActionsHandler.invokeIntention(action2, (Editor)pair.second, (PsiFile)pair.first);
            });
        }, text2, null);
        return true;
    }

    private static void invokeIntention(@NotNull IntentionAction action2, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invokeIntention"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invokeIntention"));
        }
        PsiElement elementToMakeWritable = action2.getElementToMakeWritable(file2);
        if (elementToMakeWritable != null && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{elementToMakeWritable})) {
            return;
        }
        Runnable r2 = () -> {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$invokeIntention$3"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$invokeIntention$3"));
            }
            action2.invoke(file2.getProject(), editor, file2);
        };
        if (action2.startInWriteAction()) {
            WriteAction.run(r2::run);
        } else {
            r2.run();
        }
    }

    static Pair<PsiFile, Editor> chooseFileForAction(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseFileForAction"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseFileForAction"));
        }
        return hostEditor == null ? Pair.create((Object)hostFile, null) : ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<PsiFile, Editor>)((PairProcessor)(psiFile, editor) -> {
            if (action2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "lambda$chooseFileForAction$4"));
            }
            return ShowIntentionActionsHandler.availableFor(psiFile, editor, action2);
        }));
    }
}

