/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsInSuppressedPlaceIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionManagerImpl
extends IntentionManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl");
    private final List<IntentionAction> myActions = ContainerUtil.createLockFreeCopyOnWriteList();
    private final IntentionManagerSettings mySettings;
    private final Alarm myInitActionsAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);

    public IntentionManagerImpl(IntentionManagerSettings intentionManagerSettings) {
        this.mySettings = intentionManagerSettings;
        this.addAction(new EditInspectionToolsSettingsInSuppressedPlaceIntention());
        ExtensionPoint point = Extensions.getArea(null).getExtensionPoint(EP_INTENTION_ACTIONS);
        point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<IntentionActionBean>(){

            public void extensionAdded(@NotNull IntentionActionBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1", "extensionAdded"));
                }
                IntentionManagerImpl.this.registerIntentionFromBean(extension);
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$1", "extensionRemoved"));
                }
            }
        });
    }

    private void registerIntentionFromBean(@NotNull IntentionActionBean extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionFromBean"));
        }
        Runnable runnable2 = () -> {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "lambda$registerIntentionFromBean$0"));
            }
            String descriptionDirectoryName = extension.getDescriptionDirectoryName();
            String[] categories = extension.getCategories();
            IntentionAction instance2 = IntentionManagerImpl.createIntentionActionWrapper(extension, categories);
            if (categories == null) {
                this.addAction(instance2);
            } else if (descriptionDirectoryName != null) {
                this.addAction(instance2);
                this.mySettings.registerIntentionMetaData(instance2, categories, descriptionDirectoryName, extension.getMetadataClassLoader());
            } else {
                this.registerIntentionAndMetaData(instance2, categories);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            this.myInitActionsAlarm.addRequest(runnable2, 300);
        }
    }

    public void dispose() {
    }

    private static IntentionAction createIntentionActionWrapper(@NotNull IntentionActionBean intentionActionBean, String[] categories) {
        if (intentionActionBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActionBean", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "createIntentionActionWrapper"));
        }
        return new IntentionActionWrapper(intentionActionBean, categories);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action2, String ... category) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        this.registerIntentionAndMetaData(action2, category, IntentionManagerImpl.getDescriptionDirectoryName(action2));
    }

    @NotNull
    private static String getDescriptionDirectoryName(IntentionAction action2) {
        if (action2 instanceof IntentionActionWrapper) {
            IntentionActionWrapper wrapper = (IntentionActionWrapper)action2;
            String string2 = IntentionManagerImpl.getDescriptionDirectoryName(wrapper.getImplementationClassName());
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getDescriptionDirectoryName"));
            }
            return string2;
        }
        String string3 = IntentionManagerImpl.getDescriptionDirectoryName(action2.getClass().getName());
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getDescriptionDirectoryName"));
        }
        return string3;
    }

    private static String getDescriptionDirectoryName(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action2, @NotNull String[] category, @NotNull @NonNls String descriptionDirectoryName) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionDirectoryName", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        this.addAction(action2);
        this.mySettings.registerIntentionMetaData(action2, category, descriptionDirectoryName);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action2, @NotNull String[] category, @NotNull String description, @NotNull String exampleFileExtension, @NotNull String[] exampleTextBefore, @NotNull String[] exampleTextAfter) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (exampleFileExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleFileExtension", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (exampleTextBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleTextBefore", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        if (exampleTextAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleTextAfter", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "registerIntentionAndMetaData"));
        }
        this.addAction(action2);
        IntentionActionMetaData metaData = new IntentionActionMetaData(action2, category, new PlainTextDescriptor(description, "description.html"), IntentionManagerImpl.mapToDescriptors(exampleTextBefore, "before." + exampleFileExtension), IntentionManagerImpl.mapToDescriptors(exampleTextAfter, "after." + exampleFileExtension));
        this.mySettings.registerMetaData(metaData);
    }

    public void unregisterIntention(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "unregisterIntention"));
        }
        this.myActions.remove(intentionAction);
        this.mySettings.unregisterMetaData(intentionAction);
    }

    private static TextDescriptor[] mapToDescriptors(String[] texts, @NonNls String fileName) {
        TextDescriptor[] result2 = new TextDescriptor[texts.length];
        for (int i2 = 0; i2 < texts.length; ++i2) {
            result2[i2] = new PlainTextDescriptor(texts[i2], fileName);
        }
        return result2;
    }

    @NotNull
    public List<IntentionAction> getStandardIntentionOptions(@NotNull HighlightDisplayKey displayKey, @NotNull PsiElement context2) {
        if (displayKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayKey", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getStandardIntentionOptions"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getStandardIntentionOptions"));
        }
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>(9);
        options.add(new EditInspectionToolsSettingsAction(displayKey));
        options.add(new RunInspectionIntention(displayKey));
        options.add((IntentionAction)new DisableInspectionToolAction(displayKey));
        ArrayList<IntentionAction> arrayList = options;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getStandardIntentionOptions"));
        }
        return arrayList;
    }

    @Nullable
    public IntentionAction createFixAllIntention(InspectionToolWrapper toolWrapper, IntentionAction action2) {
        LocalInspectionToolWrapper localWrapper;
        if (toolWrapper instanceof GlobalInspectionToolWrapper && (localWrapper = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper()) != null) {
            return this.createFixAllIntention(localWrapper, action2);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            Class<?> aClass = action2.getClass();
            if (action2 instanceof QuickFixWrapper) {
                aClass = ((QuickFixWrapper)action2).getFix().getClass();
            }
            return new CleanupInspectionIntention(toolWrapper, aClass, action2.getText());
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionTool wrappedTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            if (wrappedTool instanceof GlobalSimpleInspectionTool && (action2 instanceof LocalQuickFix || action2 instanceof QuickFixWrapper)) {
                Class<?> aClass = action2.getClass();
                if (action2 instanceof QuickFixWrapper) {
                    aClass = ((QuickFixWrapper)action2).getFix().getClass();
                }
                return new CleanupInspectionIntention(toolWrapper, aClass, action2.getText());
            }
        } else {
            throw new AssertionError((Object)("unknown tool: " + toolWrapper));
        }
        return null;
    }

    @NotNull
    public LocalQuickFix convertToFix(final @NotNull IntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "convertToFix"));
        }
        if (action2 instanceof LocalQuickFix) {
            LocalQuickFix localQuickFix = (LocalQuickFix)action2;
            if (localQuickFix == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "convertToFix"));
            }
            return localQuickFix;
        }
        LocalQuickFix localQuickFix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string2 = action2.getText();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "getName"));
                }
                return string2;
            }

            @NotNull
            public String getFamilyName() {
                String string2 = action2.getFamilyName();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "getFamilyName"));
                }
                return string2;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "applyFix"));
                }
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl$2", "applyFix"));
                }
                PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
                try {
                    action2.invoke(project2, (Editor)new LazyEditor(psiFile), psiFile);
                }
                catch (IncorrectOperationException e2) {
                    LOG.error((Throwable)e2);
                }
            }
        };
        if (localQuickFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "convertToFix"));
        }
        return localQuickFix;
    }

    public void addAction(@NotNull IntentionAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "addAction"));
        }
        this.myActions.add(action2);
    }

    @NotNull
    public IntentionAction[] getIntentionActions() {
        IntentionAction[] intentionActionArray = (IntentionAction[])ArrayUtil.stripTrailingNulls((Object[])this.myActions.toArray(new IntentionAction[this.myActions.size()]));
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getIntentionActions"));
        }
        return intentionActionArray;
    }

    @NotNull
    public IntentionAction[] getAvailableIntentionActions() {
        ArrayList<IntentionAction> list2 = new ArrayList<IntentionAction>(this.myActions.size());
        for (IntentionAction action2 : this.myActions) {
            if (!this.mySettings.isEnabled(action2)) continue;
            list2.add(action2);
        }
        IntentionAction[] intentionActionArray = list2.toArray(new IntentionAction[list2.size()]);
        if (intentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionManagerImpl", "getAvailableIntentionActions"));
        }
        return intentionActionArray;
    }

    public boolean hasActiveRequests() {
        return !this.myInitActionsAlarm.isEmpty();
    }
}

