/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ComparingClassifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ForceableComparable;
import com.intellij.util.ProcessingContext;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingComparingClassifier
extends ComparingClassifier<LookupElement> {
    private final Map<LookupElement, Comparable> myWeights = new IdentityHashMap<LookupElement, Comparable>();
    private final LookupElementWeigher myWeigher;
    private Ref<Comparable> myFirstWeight;
    private boolean myPrimitive = true;
    private int myPrefixChanges = -1;

    public CachingComparingClassifier(Classifier<LookupElement> next, LookupElementWeigher weigher) {
        super(next, weigher.toString(), weigher.isNegated());
        this.myWeigher = weigher;
    }

    @Override
    @Nullable
    public final Comparable getWeight(LookupElement element, ProcessingContext context2) {
        Comparable w2 = this.myWeights.get(element);
        if (w2 == null && this.myWeigher.isPrefixDependent()) {
            w2 = this.myWeigher.weigh(element, (WeighingContext)context2.get(CompletionLookupArranger.WEIGHING_CONTEXT));
            this.myWeights.put(element, w2);
        }
        return w2;
    }

    @Override
    public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "removeElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "removeElement"));
        }
        this.myWeights.remove(element);
        super.removeElement(element, context2);
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "classify"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "classify"));
        }
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            Iterable<LookupElement> iterable = this.myNext.classify(source, context2);
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "classify"));
            }
            return iterable;
        }
        this.checkPrefixChanged(context2);
        Iterable<LookupElement> iterable = super.classify(source, context2);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "classify"));
        }
        return iterable;
    }

    private void checkPrefixChanged(ProcessingContext context2) {
        int actualPrefixChanges = (Integer)context2.get(CompletionLookupArranger.PREFIX_CHANGES);
        if (this.myWeigher.isPrefixDependent() && this.myPrefixChanges != actualPrefixChanges) {
            this.myPrefixChanges = actualPrefixChanges;
            this.myWeights.clear();
        }
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items2, @NotNull ProcessingContext context2) {
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "getSortingWeights"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "getSortingWeights"));
        }
        this.checkPrefixChanged(context2);
        List<Pair<LookupElement, Object>> list2 = super.getSortingWeights(items2, context2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "getSortingWeights"));
        }
        return list2;
    }

    @Override
    public void addElement(@NotNull LookupElement t2, @NotNull ProcessingContext context2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "addElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/CachingComparingClassifier", "addElement"));
        }
        Comparable weight = this.myWeigher.weigh(t2, (WeighingContext)context2.get(CompletionLookupArranger.WEIGHING_CONTEXT));
        if (weight instanceof ForceableComparable) {
            ((ForceableComparable)weight).force();
        }
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            if (this.myFirstWeight == null) {
                this.myFirstWeight = Ref.create((Object)weight);
            } else if (!Comparing.equal((Object)this.myFirstWeight.get(), (Object)weight)) {
                this.myPrimitive = false;
            }
        }
        this.myWeights.put(t2, weight);
        super.addElement(t2, context2);
    }
}

