/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Classifier<T> {
    protected final Classifier<T> myNext;
    private final String myName;

    protected Classifier(Classifier<T> next, String name) {
        this.myNext = next;
        this.myName = name;
    }

    public void addElement(@NotNull T t2, @NotNull ProcessingContext context2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/codeInsight/lookup/Classifier", "addElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/Classifier", "addElement"));
        }
        if (this.myNext != null) {
            this.myNext.addElement(t2, context2);
        }
    }

    @NotNull
    public abstract Iterable<T> classify(@NotNull Iterable<T> var1, @NotNull ProcessingContext var2);

    @NotNull
    public abstract List<Pair<T, Object>> getSortingWeights(@NotNull Iterable<T> var1, @NotNull ProcessingContext var2);

    @Nullable
    public final Classifier<T> getNext() {
        return this.myNext;
    }

    public void removeElement(@NotNull T element, @NotNull ProcessingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/lookup/Classifier", "removeElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/Classifier", "removeElement"));
        }
        if (this.myNext != null) {
            this.myNext.removeElement(element, context2);
        }
    }

    @NotNull
    public final String getPresentableName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/Classifier", "getPresentableName"));
        }
        return string2;
    }
}

