/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SizedIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DefaultLookupItemRenderer
extends LookupElementRenderer<LookupItem> {
    public static final DefaultLookupItemRenderer INSTANCE = new DefaultLookupItemRenderer();
    private static final Icon SAMPLE_ICON = PlatformIcons.CLASS_ICON;

    public void renderElement(LookupItem item, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)item, presentation.isReal()));
        presentation.setItemText(DefaultLookupItemRenderer.getName(item));
        presentation.setItemTextBold(item.getAttribute(LookupItem.HIGHLIGHTED_ATTR) != null);
        presentation.setTailText(DefaultLookupItemRenderer.getText2(item), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        presentation.setTypeText(DefaultLookupItemRenderer.getText3(item), null);
    }

    @Nullable
    public static Icon getRawIcon(LookupElement item, boolean real) {
        Icon icon = DefaultLookupItemRenderer._getRawIcon(item, real);
        if (icon instanceof ScalableIcon) {
            icon = ((ScalableIcon)icon).scale(1.0f);
        }
        if (icon != null && icon.getIconHeight() > SAMPLE_ICON.getIconHeight()) {
            return new SizedIcon(icon, icon.getIconWidth(), SAMPLE_ICON.getIconHeight());
        }
        return icon;
    }

    @Nullable
    private static Icon _getRawIcon(LookupElement item, boolean real) {
        Icon icon;
        if (item instanceof LookupItem && (icon = (Icon)((LookupItem)item).getAttribute(LookupItem.ICON_ATTR)) != null) {
            return icon;
        }
        Object o2 = item.getObject();
        if (!real) {
            if (item.getObject() instanceof String) {
                return EmptyIcon.ICON_0;
            }
            return EmptyIcon.create((int)(SAMPLE_ICON.getIconWidth() * 2), (int)SAMPLE_ICON.getIconHeight());
        }
        if (o2 instanceof Iconable && !(o2 instanceof PsiElement)) {
            return ((Iconable)o2).getIcon(1);
        }
        PsiElement element = item.getPsiElement();
        if (element != null && element.isValid()) {
            return element.getIcon(1);
        }
        return null;
    }

    @Nullable
    private static String getText3(LookupItem item) {
        Object o2 = item.getObject();
        String text2 = o2 instanceof LookupValueWithUIHint ? ((LookupValueWithUIHint)o2).getTypeHint() : (String)item.getAttribute(LookupItem.TYPE_TEXT_ATTR);
        return text2;
    }

    private static String getText2(LookupItem item) {
        return (String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR);
    }

    private static String getName(LookupItem item) {
        String presentableText = item.getPresentableText();
        if (presentableText != null) {
            return presentableText;
        }
        Object o2 = item.getObject();
        String name = null;
        if (o2 instanceof PsiElement) {
            PsiElement element = (PsiElement)o2;
            if (element.isValid()) {
                name = PsiUtilCore.getName((PsiElement)element);
            }
        } else {
            name = o2 instanceof PsiMetaData ? ((PsiMetaData)o2).getName() : (o2 instanceof PresentableLookupValue ? ((PresentableLookupValue)o2).getPresentation() : String.valueOf(o2));
        }
        if (name == null) {
            name = "";
        }
        return name;
    }
}

