/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import org.jetbrains.annotations.Nullable;

public abstract class TailTypeDecorator<T extends LookupElement>
extends LookupElementDecorator<T> {
    public TailTypeDecorator(T delegate2) {
        super(delegate2);
    }

    public static <T extends LookupElement> TailTypeDecorator<T> withTail(T element, final TailType type) {
        return new TailTypeDecorator<T>(element){

            @Override
            protected TailType computeTailType(InsertionContext context2) {
                return type;
            }
        };
    }

    @Nullable
    protected abstract TailType computeTailType(InsertionContext var1);

    public void handleInsert(InsertionContext context2) {
        LookupElement delegate2 = this.getDelegate();
        TailType tailType = this.computeTailType(context2);
        LookupItem lookupItem = (LookupItem)delegate2.as(LookupItem.CLASS_CONDITION_KEY);
        if (lookupItem != null && tailType != null) {
            lookupItem.setTailType(TailType.UNKNOWN);
        }
        delegate2.handleInsert(context2);
        if (tailType != null && tailType.isApplicable(context2)) {
            PostprocessReformattingAspect.getInstance(context2.getProject()).doPostponedFormatting();
            int tailOffset = context2.getTailOffset();
            if (tailOffset < 0) {
                throw new AssertionError((Object)("tailOffset < 0: delegate=" + this.getDelegate() + "; this=" + (Object)((Object)this) + "; tail=" + tailType));
            }
            tailType.processTail(context2.getEditor(), tailOffset);
        }
    }
}

