/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LookupActionsStep
extends BaseListPopupStep<LookupElementAction>
implements ClosableByLeftArrow {
    private final LookupImpl myLookup;
    private final LookupElement myLookupElement;
    private final Icon myEmptyIcon;

    public LookupActionsStep(Collection<LookupElementAction> actions2, LookupImpl lookup, LookupElement lookupElement) {
        super(null, new ArrayList<LookupElementAction>(actions2));
        this.myLookup = lookup;
        this.myLookupElement = lookupElement;
        int w2 = 0;
        int h2 = 0;
        for (LookupElementAction action2 : actions2) {
            Icon icon = action2.getIcon();
            if (icon == null) continue;
            w2 = Math.max(w2, icon.getIconWidth());
            h2 = Math.max(h2, icon.getIconHeight());
        }
        this.myEmptyIcon = EmptyIcon.create((int)w2, (int)h2);
    }

    public PopupStep onChosen(LookupElementAction selectedValue, boolean finalChoice) {
        LookupElementAction.Result result2 = selectedValue.performLookupAction();
        if (result2 == LookupElementAction.Result.HIDE_LOOKUP) {
            this.myLookup.hideLookup(true);
        } else if (result2 == LookupElementAction.Result.REFRESH_ITEM) {
            this.myLookup.updateLookupWidth(this.myLookupElement);
            this.myLookup.requestResize();
            this.myLookup.refreshUi(false, true);
        } else if (result2 instanceof LookupElementAction.Result.ChooseItem) {
            this.myLookup.setCurrentItem(((LookupElementAction.Result.ChooseItem)result2).item);
            CommandProcessor.getInstance().executeCommand(this.myLookup.getProject(), () -> this.myLookup.finishLookup('\u0000'), null, null);
        }
        return FINAL_CHOICE;
    }

    public Icon getIconFor(LookupElementAction aValue) {
        return LookupCellRenderer.augmentIcon(this.myLookup.getEditor(), aValue.getIcon(), this.myEmptyIcon);
    }

    @NotNull
    public String getTextFor(LookupElementAction value2) {
        String string2 = value2.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupActionsStep", "getTextFor"));
        }
        return string2;
    }
}

