/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.Advertiser;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupActionsStep;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupOffsets;
import com.intellij.codeInsight.lookup.impl.LookupPreview;
import com.intellij.codeInsight.lookup.impl.LookupUi;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupImpl
extends LightweightHint
implements LookupEx,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupImpl");
    private final LookupOffsets myOffsets;
    private final Project myProject;
    private final Editor myEditor;
    private final Object myLock;
    private final JBList myList;
    final LookupCellRenderer myCellRenderer;
    private final List<LookupListener> myListeners;
    private PrefixChangeListener myPrefixChangeListener;
    private final LookupPreview myPreview;
    private final FontPreferences myFontPreferences;
    private long myStampShown;
    private boolean myShown;
    private boolean myDisposed;
    private boolean myHidden;
    private boolean mySelectionTouched;
    private FocusDegree myFocusDegree;
    private volatile boolean myCalculating;
    private final Advertiser myAdComponent;
    volatile int myLookupTextWidth;
    private boolean myChangeGuard;
    private volatile LookupArranger myArranger;
    private LookupArranger myPresentableArranger;
    private final Map<LookupElement, Font> myCustomFonts;
    private boolean myStartCompletionWhenNothingMatches;
    boolean myResizePending;
    private boolean myFinishing;
    boolean myUpdating;
    private LookupUi myUi;
    private static String staticDisposeTrace = null;
    private String disposeTrace;

    public LookupImpl(Project project2, Editor editor, @NotNull LookupArranger arranger) {
        if (arranger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arranger", "com/intellij/codeInsight/lookup/impl/LookupImpl", "<init>"));
        }
        super(new JPanel(new BorderLayout()));
        this.myLock = new Object();
        this.myList = new JBList((ListModel)new CollectionListModel((Object[])new LookupElement[0])){

            protected void processKeyEvent(@NotNull KeyEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "processKeyEvent"));
                }
                char keyChar = e2.getKeyChar();
                if (keyChar == '\n' || keyChar == '\t') {
                    IdeFocusManager.getInstance((Project)LookupImpl.this.myProject).requestFocus((Component)LookupImpl.this.myEditor.getContentComponent(), true).doWhenDone(() -> {
                        if (e2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "lambda$processKeyEvent$0"));
                        }
                        IdeEventQueue.getInstance().getKeyEventDispatcher().dispatchKeyEvent(e2);
                    });
                    return;
                }
                super.processKeyEvent(e2);
            }

            @NotNull
            protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
                CompletionExtender completionExtender = new CompletionExtender((JList)((Object)this));
                if (completionExtender == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "createExpandableItemsHandler"));
                }
                return completionExtender;
            }
        };
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPrefixChangeListener = new PrefixChangeListener.Adapter(){};
        this.myPreview = new LookupPreview(this);
        this.myFontPreferences = new FontPreferences();
        this.myStampShown = 0L;
        this.myShown = false;
        this.myDisposed = false;
        this.myHidden = false;
        this.myFocusDegree = FocusDegree.FOCUSED;
        this.myLookupTextWidth = 50;
        this.myCustomFonts = ContainerUtil.createConcurrentWeakMap((int)10, (float)0.75f, (int)Runtime.getRuntime().availableProcessors(), (TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.disposeTrace = null;
        this.setForceShowAsPopup(true);
        this.setCancelOnClickOutside(false);
        this.setResizable(true);
        AbstractPopup.suppressMacCornerFor((JComponent)this.getComponent());
        this.myProject = project2;
        this.myEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
        this.myArranger = arranger;
        this.myPresentableArranger = arranger;
        this.myEditor.getColorsScheme().getFontPreferences().copyTo(this.myFontPreferences);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        this.myCellRenderer = new LookupCellRenderer(this);
        this.myList.setCellRenderer((ListCellRenderer)this.myCellRenderer);
        this.myList.setFocusable(false);
        this.myList.setFixedCellWidth(50);
        AccessibleContextUtil.setParent((JComponent)this.myList, (Component)this.myEditor.getContentComponent());
        this.myList.setSelectionMode(0);
        this.myList.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.myList.getExpandableItemsHandler();
        this.myAdComponent = new Advertiser();
        this.myOffsets = new LookupOffsets(this.myEditor);
        CollectionListModel<LookupElement> model2 = this.getListModel();
        this.addEmptyItem(model2);
        this.updateListHeight((ListModel)model2);
        this.addListeners();
    }

    private CollectionListModel<LookupElement> getListModel() {
        return (CollectionListModel)this.myList.getModel();
    }

    public void setArranger(LookupArranger arranger) {
        this.myArranger = arranger;
    }

    public FocusDegree getFocusDegree() {
        return this.myFocusDegree;
    }

    public boolean isFocused() {
        return this.getFocusDegree() == FocusDegree.FOCUSED;
    }

    public void setFocusDegree(FocusDegree focusDegree) {
        this.myFocusDegree = focusDegree;
    }

    public boolean isCalculating() {
        return this.myCalculating;
    }

    public void setCalculating(boolean calculating) {
        this.myCalculating = calculating;
        if (this.myUi != null) {
            this.myUi.setCalculating(calculating);
        }
    }

    public void markSelectionTouched() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.mySelectionTouched = true;
        this.myList.repaint();
    }

    public void setSelectionTouched(boolean selectionTouched) {
        this.mySelectionTouched = selectionTouched;
    }

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    protected void repaintLookup(boolean onExplicitAction, boolean reused, boolean selectionVisible, boolean itemsChanged) {
        this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
    }

    public void resort(boolean addAgain) {
        List<LookupElement> items2 = this.getItems();
        this.withLock(() -> {
            this.myPresentableArranger.prefixChanged(this);
            this.getListModel().removeAll();
            return null;
        });
        if (addAgain) {
            for (LookupElement item : items2) {
                this.addItem(item, this.itemMatcher(item));
            }
        }
        this.refreshUi(true, true);
    }

    public boolean addItem(LookupElement item, PrefixMatcher matcher) {
        LookupElementPresentation presentation = LookupImpl.renderItemApproximately(item);
        if (LookupImpl.containsDummyIdentifier(presentation.getItemText()) || LookupImpl.containsDummyIdentifier(presentation.getTailText()) || LookupImpl.containsDummyIdentifier(presentation.getTypeText())) {
            return false;
        }
        this.updateLookupWidth(item, presentation);
        this.withLock(() -> {
            this.myArranger.registerMatcher(item, matcher);
            this.myArranger.addElement(item, presentation);
            return null;
        });
        return true;
    }

    private static boolean containsDummyIdentifier(@Nullable String s2) {
        return s2 != null && s2.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
    }

    public void updateLookupWidth(LookupElement item) {
        this.updateLookupWidth(item, LookupImpl.renderItemApproximately(item));
    }

    private void updateLookupWidth(LookupElement item, LookupElementPresentation presentation) {
        Font customFont = this.myCellRenderer.getFontAbleToDisplay(presentation);
        if (customFont != null) {
            this.myCustomFonts.put(item, customFont);
        }
        int maxWidth = this.myCellRenderer.updateMaximumWidth(presentation, item);
        this.myLookupTextWidth = Math.max(maxWidth, this.myLookupTextWidth);
    }

    @Nullable
    public Font getCustomFont(LookupElement item, boolean bold) {
        Font font = this.myCustomFonts.get(item);
        return font == null ? null : (bold ? font.deriveFont(1) : font);
    }

    public void requestResize() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myResizePending = true;
    }

    public Collection<LookupElementAction> getActionsFor(LookupElement element) {
        CollectConsumer consumer2 = new CollectConsumer();
        for (LookupActionProvider provider : (LookupActionProvider[])LookupActionProvider.EP_NAME.getExtensions()) {
            provider.fillActions(element, this, (Consumer<LookupElementAction>)consumer2);
        }
        if (!consumer2.getResult().isEmpty()) {
            consumer2.consume((Object)new ShowHideIntentionIconLookupAction());
        }
        return consumer2.getResult();
    }

    public JList getList() {
        return this.myList;
    }

    public List<LookupElement> getItems() {
        return (List)this.withLock(() -> ContainerUtil.findAll((Collection)this.getListModel().toList(), element -> !(element instanceof EmptyLookupItem)));
    }

    public String getAdditionalPrefix() {
        return this.myOffsets.getAdditionalPrefix();
    }

    void appendPrefix(char c2) {
        this.checkValid();
        this.myOffsets.appendPrefix(c2);
        this.withLock(() -> {
            this.myPresentableArranger.prefixChanged(this);
            return null;
        });
        this.requestResize();
        this.refreshUi(false, true);
        this.ensureSelectionVisible(true);
        this.myPrefixChangeListener.afterAppend(c2);
    }

    public void setStartCompletionWhenNothingMatches(boolean startCompletionWhenNothingMatches) {
        this.myStartCompletionWhenNothingMatches = startCompletionWhenNothingMatches;
    }

    public boolean isStartCompletionWhenNothingMatches() {
        return this.myStartCompletionWhenNothingMatches;
    }

    public void ensureSelectionVisible(boolean forceTopSelection) {
        int firstVisibleIndex;
        if (this.isSelectionVisible() && !forceTopSelection) {
            return;
        }
        if (!forceTopSelection) {
            ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)this.myList.getSelectedIndex(), (int)1);
            return;
        }
        int top = this.myList.getSelectedIndex();
        if (top > 0) {
            --top;
        }
        if ((firstVisibleIndex = this.myList.getFirstVisibleIndex()) == top) {
            return;
        }
        ScrollingUtil.ensureRangeIsVisible((JList)this.myList, (int)top, (int)(top + this.myList.getLastVisibleIndex() - firstVisibleIndex));
    }

    boolean truncatePrefix(boolean preserveSelection) {
        if (!this.myOffsets.truncatePrefix()) {
            return false;
        }
        if (preserveSelection) {
            this.markSelectionTouched();
        }
        boolean shouldUpdate = (Boolean)this.withLock(() -> {
            this.myPresentableArranger.prefixChanged(this);
            return this.myPresentableArranger == this.myArranger;
        });
        this.requestResize();
        if (shouldUpdate) {
            this.refreshUi(false, true);
            this.ensureSelectionVisible(true);
        }
        return true;
    }

    private boolean updateList(boolean onExplicitAction, boolean reused) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.checkValid();
        CollectionListModel<LookupElement> listModel2 = this.getListModel();
        Pair pair = (Pair)this.withLock(() -> this.myPresentableArranger.arrangeItems(this, onExplicitAction || reused));
        List items2 = (List)pair.first;
        Integer toSelect = (Integer)pair.second;
        if (toSelect == null || toSelect < 0 || items2.size() > 0 && toSelect >= items2.size()) {
            LOG.error("Arranger " + this.myPresentableArranger + " returned invalid selection index=" + toSelect + "; items=" + items2);
            toSelect = 0;
        }
        this.myOffsets.checkMinPrefixLengthChanges(items2, this);
        List oldModel = listModel2.toList();
        listModel2.removeAll();
        if (!items2.isEmpty()) {
            listModel2.add(items2);
        } else {
            this.addEmptyItem(listModel2);
        }
        this.updateListHeight((ListModel)listModel2);
        this.myList.setSelectedIndex(toSelect.intValue());
        return !ContainerUtil.equalsIdentity((List)oldModel, (List)items2);
    }

    protected boolean isSelectionVisible() {
        return ScrollingUtil.isIndexFullyVisible((JList)this.myList, (int)this.myList.getSelectedIndex());
    }

    private boolean checkReused() {
        return (Boolean)this.withLock(() -> {
            if (this.myPresentableArranger != this.myArranger) {
                this.myPresentableArranger = this.myArranger;
                this.myOffsets.clearAdditionalPrefix();
                this.myPresentableArranger.prefixChanged(this);
                return true;
            }
            return false;
        });
    }

    private void updateListHeight(ListModel model2) {
        this.myList.setFixedCellHeight(this.myCellRenderer.getListCellRendererComponent((JList)this.myList, model2.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height);
        this.myList.setVisibleRowCount(Math.min(model2.getSize(), UISettings.getInstance().getMaxLookupListHeight()));
    }

    private void addEmptyItem(CollectionListModel<LookupElement> model2) {
        EmptyLookupItem item = new EmptyLookupItem(this.myCalculating ? " " : LangBundle.message("completion.no.suggestions", new Object[0]), false);
        model2.add((Object)item);
        this.updateLookupWidth(item);
        this.requestResize();
    }

    private static LookupElementPresentation renderItemApproximately(LookupElement item) {
        LookupElementPresentation p2 = new LookupElementPresentation();
        item.renderElement(p2);
        return p2;
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
        }
        if (element instanceof EmptyLookupItem) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
            }
            return "";
        }
        String string2 = this.myPresentableArranger.itemPattern(element);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
        }
        return string2;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
        }
        if (item instanceof EmptyLookupItem) {
            CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher("");
            if (camelHumpMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
            }
            return camelHumpMatcher;
        }
        PrefixMatcher prefixMatcher = this.myPresentableArranger.itemMatcher(item);
        if (prefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
        }
        return prefixMatcher;
    }

    public void finishLookup(char completionChar) {
        this.finishLookup(completionChar, (LookupElement)this.myList.getSelectedValue());
    }

    public void finishLookup(char completionChar, @Nullable LookupElement item) {
        boolean writableOk;
        LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed(), (Object)"finishLookup should be called without a write action");
        PsiFile file2 = this.getPsiFile();
        boolean bl = writableOk = file2 == null || FileModificationService.getInstance().prepareFileForWrite(file2);
        if (this.myDisposed) {
            return;
        }
        if (!writableOk) {
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.finishLookupInWritableFile(completionChar, item), null, null);
    }

    void finishLookupInWritableFile(char completionChar, @Nullable LookupElement item) {
        if (item == null || !item.isValid() || item instanceof EmptyLookupItem || item.getObject() instanceof DeferredUserLookupValue && item.as(LookupItem.CLASS_CONDITION_KEY) != null && !((DeferredUserLookupValue)item.getObject()).handleUserSelection((LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY), this.myProject)) {
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        if (this.myDisposed) {
            return;
        }
        String prefix = this.itemPattern(item);
        boolean plainMatch = ContainerUtil.or((Iterable)item.getAllLookupStrings(), s2 -> StringUtil.containsIgnoreCase((String)s2, (String)prefix));
        if (!plainMatch) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
        }
        this.myFinishing = true;
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myEditor.getDocument().startGuardedBlockChecking();
            try {
                this.insertLookupString(item, this.getPrefixLength(item));
            }
            finally {
                this.myEditor.getDocument().stopGuardedBlockChecking();
            }
        });
        if (this.myDisposed) {
            return;
        }
        this.doHide(false, true);
        this.fireItemSelected(item, completionChar);
    }

    public int getPrefixLength(LookupElement item) {
        return this.myOffsets.getPrefixLength(item, this);
    }

    protected void insertLookupString(LookupElement item, final int prefix) {
        final String lookupString = this.getCaseCorrectedLookupString(item);
        final Editor hostEditor = this.getTopLevelEditor();
        hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                EditorModificationUtil.deleteSelectedText((Editor)hostEditor);
                int caretOffset = hostEditor.getCaretModel().getOffset();
                int offset = LookupImpl.this.insertLookupInDocumentWindowIfNeeded(caretOffset, prefix, lookupString);
                hostEditor.getCaretModel().moveToOffset(offset);
                hostEditor.getSelectionModel().removeSelection();
            }
        });
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private int insertLookupInDocumentWindowIfNeeded(int caretOffset, int prefix, String lookupString) {
        List ranges;
        DocumentWindow document = this.getInjectedDocument(caretOffset);
        if (document == null) {
            return LookupImpl.insertLookupInDocument(caretOffset, this.myEditor.getDocument(), prefix, lookupString);
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)document);
        int offset = document.hostToInjected(caretOffset);
        int lookupStart = Math.min(offset, Math.max(offset - prefix, 0));
        int diff = -1;
        if (file2 != null && !(ranges = InjectedLanguageManager.getInstance((Project)this.myProject).intersectWithAllEditableFragments(file2, TextRange.create((int)lookupStart, (int)offset))).isEmpty()) {
            diff = ((TextRange)ranges.get(0)).getStartOffset() - lookupStart;
            if (ranges.size() == 1 && diff == 0) {
                diff = -1;
            }
        }
        if (diff == -1) {
            return LookupImpl.insertLookupInDocument(caretOffset, this.myEditor.getDocument(), prefix, lookupString);
        }
        return document.injectedToHost(LookupImpl.insertLookupInDocument(offset, (Document)document, prefix - diff, diff == 0 ? lookupString : lookupString.substring(diff)));
    }

    private static int insertLookupInDocument(int caretOffset, Document document, int prefix, String lookupString) {
        int lookupStart = Math.min(caretOffset, Math.max(caretOffset - prefix, 0));
        int len = document.getTextLength();
        LOG.assertTrue(lookupStart >= 0 && lookupStart <= len, (Object)("ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len));
        LOG.assertTrue(caretOffset >= 0 && caretOffset <= len, (Object)("co: " + caretOffset + " doc: " + len));
        document.replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
        return lookupStart + lookupString.length();
    }

    private String getCaseCorrectedLookupString(LookupElement item) {
        String lookupString = item.getLookupString();
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        String prefix = this.itemPattern(item);
        int length = prefix.length();
        if (length == 0 || !this.itemMatcher(item).prefixMatches(prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        for (int i2 = 0; i2 < length && (isAllLower || isAllUpper || sameCase); ++i2) {
            char c2 = prefix.charAt(i2);
            boolean isLower = Character.isLowerCase(c2);
            boolean isUpper = Character.isUpperCase(c2);
            if (!isLower && !isUpper) continue;
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && i2 < lookupString.length() && isLower == Character.isLowerCase(lookupString.charAt(i2));
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            return lookupString.toLowerCase();
        }
        if (isAllUpper) {
            return StringUtil.toUpperCase((String)lookupString);
        }
        return lookupString;
    }

    public int getLookupStart() {
        return this.myOffsets.getLookupStart(this.disposeTrace);
    }

    public int getLookupOriginalStart() {
        return this.myOffsets.getLookupOriginalStart();
    }

    public boolean performGuardedChange(Runnable change) {
        boolean result2;
        this.checkValid();
        assert (!this.myChangeGuard) : "already in change";
        this.myEditor.getDocument().startGuardedBlockChecking();
        this.myChangeGuard = true;
        try {
            result2 = this.myOffsets.performGuardedChange(change);
        }
        finally {
            this.myEditor.getDocument().stopGuardedBlockChecking();
            this.myChangeGuard = false;
        }
        if (!result2 || this.myDisposed) {
            this.hideLookup(false);
            return false;
        }
        if (this.isVisible()) {
            HintManagerImpl.updateLocation(this, this.myEditor, this.myUi.calculatePosition().getLocation());
        }
        this.checkValid();
        return true;
    }

    @Override
    public boolean vetoesHiding() {
        return this.myChangeGuard;
    }

    public boolean isAvailableToUser() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myShown;
        }
        return this.isVisible();
    }

    public boolean isShown() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        return this.myShown;
    }

    public boolean showLookup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkValid();
        LOG.assertTrue(!this.myShown);
        this.myShown = true;
        this.myStampShown = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!this.myEditor.getContentComponent().isShowing()) {
            this.hideLookup(false);
            return false;
        }
        this.myAdComponent.showRandomText();
        this.myUi = new LookupUi(this, this.myAdComponent, this.myList, this.myProject);
        this.myUi.setCalculating(this.myCalculating);
        Point p2 = this.myUi.calculatePosition().getLocation();
        try {
            HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myEditor, p2, 129, 0, false, HintManagerImpl.createHintHint(this.myEditor, p2, this, (short)2).setAwtTooltip(false));
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
        if (!this.isVisible() || !this.myList.isShowing()) {
            this.hideLookup(false);
            return false;
        }
        return true;
    }

    public Advertiser getAdvertiser() {
        return this.myAdComponent;
    }

    public boolean mayBeNoticed() {
        return this.myStampShown > 0L && System.currentTimeMillis() - this.myStampShown > 300L;
    }

    private void addListeners() {
        this.myEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e2) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hideLookup(false);
                }
            }
        }, (Disposable)this);
        CaretAdapter caretListener2 = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e2) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hideLookup(false);
                }
            }
        };
        SelectionListener selectionListener2 = new SelectionListener(){

            public void selectionChanged(SelectionEvent e2) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hideLookup(false);
                }
            }
        };
        EditorMouseAdapter mouseListener = new EditorMouseAdapter(){

            public void mouseClicked(EditorMouseEvent e2) {
                e2.consume();
                LookupImpl.this.hideLookup(false);
            }
        };
        this.myEditor.getCaretModel().addCaretListener((CaretListener)caretListener2);
        this.myEditor.getSelectionModel().addSelectionListener(selectionListener2);
        this.myEditor.addEditorMouseListener((EditorMouseListener)mouseListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable((CaretListener)caretListener2, selectionListener2, (EditorMouseListener)mouseListener){
            final /* synthetic */ CaretListener val$caretListener;
            final /* synthetic */ SelectionListener val$selectionListener;
            final /* synthetic */ EditorMouseListener val$mouseListener;
            {
                this.val$caretListener = caretListener2;
                this.val$selectionListener = selectionListener2;
                this.val$mouseListener = editorMouseListener;
            }

            public void dispose() {
                LookupImpl.this.myEditor.getCaretModel().removeCaretListener(this.val$caretListener);
                LookupImpl.this.myEditor.getSelectionModel().removeSelectionListener(this.val$selectionListener);
                LookupImpl.this.myEditor.removeEditorMouseListener(this.val$mouseListener);
            }
        });
        JComponent editorComponent = this.myEditor.getContentComponent();
        if (editorComponent.isShowing()) {
            Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)editorComponent, new Activatable(){

                public void showNotify() {
                }

                public void hideNotify() {
                    LookupImpl.this.hideLookup(false);
                }
            }));
        }
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private LookupElement oldItem = null;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$10", "valueChanged"));
                }
                if (!LookupImpl.this.myUpdating) {
                    LookupElement item = LookupImpl.this.getCurrentItem();
                    LookupImpl.this.fireCurrentItemChanged(this.oldItem, item);
                    this.oldItem = item;
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e2, int clickCount) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$11", "onClick"));
                }
                LookupImpl.this.setFocusDegree(FocusDegree.FOCUSED);
                LookupImpl.this.markSelectionTouched();
                if (clickCount == 2) {
                    CommandProcessor.getInstance().executeCommand(LookupImpl.this.myProject, () -> LookupImpl.this.finishLookup('\n'), "", null);
                }
                return true;
            }
        }.installOn((Component)this.myList);
    }

    @Nullable
    public LookupElement getCurrentItem() {
        LookupElement item = (LookupElement)this.myList.getSelectedValue();
        return item instanceof EmptyLookupItem ? null : item;
    }

    @Override
    public void setCurrentItem(LookupElement item) {
        this.markSelectionTouched();
        this.myList.setSelectedValue((Object)item, false);
    }

    public void addLookupListener(LookupListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeLookupListener(LookupListener listener2) {
        this.myListeners.remove(listener2);
    }

    public Rectangle getCurrentItemBounds() {
        Rectangle itmBounds;
        int index = this.myList.getSelectedIndex();
        if (index < 0) {
            LOG.error("No selected element, size=" + this.getListModel().getSize() + "; items" + this.getItems());
        }
        if ((itmBounds = this.myList.getCellBounds(index, index)) == null) {
            LOG.error("No bounds for " + index + "; size=" + this.getListModel().getSize());
            return null;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint((Component)this.myList, itmBounds.x, itmBounds.y, this.getComponent());
        itmBounds.x = layeredPanePoint.x;
        itmBounds.y = layeredPanePoint.y;
        return itmBounds;
    }

    public void fireItemSelected(@Nullable LookupElement item, char completionChar) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        this.myArranger.itemSelected(item, completionChar);
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    listener2.itemSelected(event);
                }
                catch (Throwable e2) {
                    LOG.error(e2);
                }
            }
        }
    }

    private void fireLookupCanceled(boolean explicitly) {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, explicitly);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    listener2.lookupCanceled(event);
                }
                catch (Throwable e2) {
                    LOG.error(e2);
                }
            }
        }
    }

    private void fireCurrentItemChanged(@Nullable LookupElement oldItem, @Nullable LookupElement currentItem) {
        if (oldItem != currentItem && !this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, currentItem, '\u0000');
            for (LookupListener listener2 : this.myListeners) {
                listener2.currentItemChanged(event);
            }
        }
        this.myPreview.updatePreview(currentItem);
    }

    public boolean fillInCommonPrefix(boolean explicitlyInvoked) {
        LookupElement item;
        int i2;
        if (explicitlyInvoked) {
            this.setFocusDegree(FocusDegree.FOCUSED);
        }
        if (explicitlyInvoked && this.myCalculating) {
            return false;
        }
        if (!explicitlyInvoked && this.mySelectionTouched) {
            return false;
        }
        CollectionListModel<LookupElement> listModel2 = this.getListModel();
        if (listModel2.getSize() <= 1) {
            return false;
        }
        if (listModel2.getSize() == 0) {
            return false;
        }
        LookupElement firstItem = (LookupElement)listModel2.getElementAt(0);
        if (listModel2.getSize() == 1 && firstItem instanceof EmptyLookupItem) {
            return false;
        }
        PrefixMatcher firstItemMatcher = this.itemMatcher(firstItem);
        String oldPrefix = firstItemMatcher.getPrefix();
        String presentPrefix = oldPrefix + this.getAdditionalPrefix();
        String commonPrefix = this.getCaseCorrectedLookupString(firstItem);
        for (i2 = 1; i2 < listModel2.getSize(); ++i2) {
            item = (LookupElement)listModel2.getElementAt(i2);
            if (item instanceof EmptyLookupItem) {
                return false;
            }
            if (!oldPrefix.equals(this.itemMatcher(item).getPrefix())) {
                return false;
            }
            String lookupString = this.getCaseCorrectedLookupString(item);
            int length = Math.min(commonPrefix.length(), lookupString.length());
            if (length < commonPrefix.length()) {
                commonPrefix = commonPrefix.substring(0, length);
            }
            for (int j2 = 0; j2 < length; ++j2) {
                if (commonPrefix.charAt(j2) == lookupString.charAt(j2)) continue;
                commonPrefix = lookupString.substring(0, j2);
                break;
            }
            if (commonPrefix.length() != 0 && commonPrefix.length() >= presentPrefix.length()) continue;
            return false;
        }
        if (commonPrefix.equals(presentPrefix)) {
            return false;
        }
        for (i2 = 0; i2 < listModel2.getSize(); ++i2) {
            item = (LookupElement)listModel2.getElementAt(i2);
            if (this.itemMatcher(item).cloneWithPrefix(commonPrefix).prefixMatches(item)) continue;
            return false;
        }
        this.myOffsets.setInitialPrefix(presentPrefix, explicitlyInvoked);
        this.replacePrefix(presentPrefix, commonPrefix);
        return true;
    }

    public void replacePrefix(String presentPrefix, String newPrefix) {
        if (!this.performGuardedChange(() -> {
            EditorModificationUtil.deleteSelectedText((Editor)this.myEditor);
            int offset = this.myEditor.getCaretModel().getOffset();
            int start2 = offset - presentPrefix.length();
            this.myEditor.getDocument().replaceString(start2, offset, (CharSequence)newPrefix);
            this.myOffsets.clearAdditionalPrefix();
            this.myEditor.getCaretModel().moveToOffset(start2 + newPrefix.length());
        })) {
            return;
        }
        this.withLock(() -> {
            this.myPresentableArranger.prefixReplaced(this, newPrefix);
            return null;
        });
        this.refreshUi(true, true);
    }

    @Nullable
    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getEditor().getDocument());
    }

    public boolean isCompletion() {
        return this.myArranger instanceof CompletionLookupArranger;
    }

    public PsiElement getPsiElement() {
        PsiFile file2 = this.getPsiFile();
        if (file2 == null) {
            return null;
        }
        int offset = this.getLookupStart();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            offset = editor.logicalPositionToOffset(((EditorWindow)editor).hostToInjected(this.myEditor.offsetToLogicalPosition(offset)));
        }
        if (offset > 0) {
            return file2.findElementAt(offset - 1);
        }
        return file2.findElementAt(0);
    }

    @Nullable
    private DocumentWindow getInjectedDocument(int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (hostFile != null) {
            for (DocumentWindow documentWindow : InjectedLanguageUtil.getCachedInjectedDocuments(hostFile)) {
                if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    @NotNull
    public Editor getEditor() {
        DocumentWindow documentWindow = this.getInjectedDocument(this.myEditor.getCaretModel().getOffset());
        if (documentWindow != null) {
            PsiFile injectedFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentWindow);
            Editor editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getEditor"));
            }
            return editor;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getEditor"));
        }
        return editor;
    }

    @NotNull
    public Editor getTopLevelEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getTopLevelEditor"));
        }
        return editor;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getProject"));
        }
        return project2;
    }

    public boolean isPositionedAboveCaret() {
        return this.myUi != null && this.myUi.isPositionedAboveCaret();
    }

    public boolean isSelectionTouched() {
        return this.mySelectionTouched;
    }

    public List<String> getAdvertisements() {
        return this.myAdComponent.getAdvertisements();
    }

    @Override
    public void hide() {
        this.hideLookup(true);
    }

    public void hideLookup(boolean explicitly) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHidden) {
            return;
        }
        this.doHide(true, explicitly);
    }

    private void doHide(boolean fireCanceled, boolean explicitly) {
        if (this.myDisposed) {
            LOG.error(this.disposeTrace);
        } else {
            this.myHidden = true;
            try {
                super.hide();
                Disposer.dispose((Disposable)this);
                assert (this.myDisposed);
            }
            catch (Throwable e2) {
                LOG.error(e2);
            }
        }
        if (fireCanceled) {
            this.fireLookupCanceled(explicitly);
        }
    }

    public void restorePrefix() {
        this.myOffsets.restorePrefix();
    }

    public static String getLastLookupDisposeTrace() {
        return staticDisposeTrace;
    }

    public void dispose() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        assert (this.myHidden);
        if (this.myDisposed) {
            LOG.error(this.disposeTrace);
            return;
        }
        this.myOffsets.disposeMarkers();
        this.myDisposed = true;
        staticDisposeTrace = this.disposeTrace = DebugUtil.currentStackTrace() + "\n============";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        assert (!this.myUpdating);
        LookupElement prevItem = this.getCurrentItem();
        this.myUpdating = true;
        try {
            boolean reused = mayCheckReused && this.checkReused();
            boolean selectionVisible = this.isSelectionVisible();
            boolean itemsChanged = this.updateList(onExplicitAction, reused);
            if (this.isVisible()) {
                LOG.assertTrue(!ApplicationManager.getApplication().isUnitTestMode());
                this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
            }
        }
        finally {
            this.myUpdating = false;
            this.fireCurrentItemChanged(prevItem, this.getCurrentItem());
        }
    }

    public void markReused() {
        this.withLock(() -> {
            this.myArranger = this.myArranger.createEmptyCopy();
            return this.myArranger;
        });
        this.requestResize();
    }

    public void addAdvertisement(@NotNull String text2, @Nullable Color bgColor) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/lookup/impl/LookupImpl", "addAdvertisement"));
        }
        if (LookupImpl.containsDummyIdentifier(text2)) {
            return;
        }
        this.myAdComponent.addAdvertisement(text2, bgColor);
        this.requestResize();
    }

    public boolean isLookupDisposed() {
        return this.myDisposed;
    }

    public void checkValid() {
        if (this.myDisposed) {
            throw new AssertionError((Object)("Disposed at: " + this.disposeTrace));
        }
    }

    @Override
    public void showItemPopup(JBPopup hint) {
        Rectangle bounds = this.getCurrentItemBounds();
        hint.show(new RelativePoint(this.getComponent(), new Point(bounds.x + bounds.width, bounds.y)));
    }

    @Override
    public boolean showElementActions() {
        if (!this.isVisible()) {
            return false;
        }
        LookupElement element = this.getCurrentItem();
        if (element == null) {
            return false;
        }
        Collection<LookupElementAction> actions2 = this.getActionsFor(element);
        if (actions2.isEmpty()) {
            return false;
        }
        this.showItemPopup((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LookupActionsStep(actions2, this, element)));
        return true;
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items2, boolean hideSingleValued) {
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getRelevanceObjects"));
        }
        Map map2 = (Map)this.withLock(() -> {
            if (items2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/lookup/impl/LookupImpl", "lambda$getRelevanceObjects$14"));
            }
            return this.myPresentableArranger.getRelevanceObjects(items2, hideSingleValued);
        });
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getRelevanceObjects"));
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(Computable<T> computable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        }
        Object object = this.myLock;
        synchronized (object) {
            return (T)computable.compute();
        }
    }

    public void setPrefixChangeListener(PrefixChangeListener listener2) {
        this.myPrefixChangeListener = listener2;
    }

    FontPreferences getFontPreferences() {
        return this.myFontPreferences;
    }

    public static enum FocusDegree {
        FOCUSED,
        SEMI_FOCUSED,
        UNFOCUSED;

    }
}

