/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LookupPreview {
    private final List<Inlay> myInlays = new ArrayList<Inlay>();
    private final LookupImpl myLookup;

    LookupPreview(LookupImpl lookup) {
        this.myLookup = lookup;
    }

    void updatePreview(@Nullable LookupElement item) {
        if (!Registry.is((String)"ide.lookup.preview.insertion")) {
            return;
        }
        this.myInlays.forEach(Disposer::dispose);
        this.myInlays.clear();
        String suffix = this.getSuffixText(item);
        Editor editor = this.myLookup.getTopLevelEditor();
        if (!suffix.isEmpty() && editor instanceof EditorImpl && !editor.getSelectionModel().hasSelection() && InplaceRefactoring.getActiveInplaceRenamer(editor) == null) {
            this.myLookup.performGuardedChange(() -> {
                for (Caret caret : editor.getCaretModel().getAllCarets()) {
                    LookupPreview.ensureCaretBeforeInlays(caret);
                    this.addInlay(suffix, caret.getOffset());
                }
            });
        }
    }

    private static void ensureCaretBeforeInlays(Caret caret) {
        LogicalPosition position = caret.getLogicalPosition();
        if (position.leansForward) {
            caret.moveToLogicalPosition(position.leanForward(false));
        }
    }

    private String getSuffixText(@Nullable LookupElement item) {
        if (item != null) {
            String itemText = StringUtil.notNullize((String)LookupElementPresentation.renderElement((LookupElement)item).getItemText());
            String prefix = this.myLookup.itemPattern(item);
            if (prefix.isEmpty()) {
                return itemText;
            }
            FList<TextRange> fragments = LookupCellRenderer.getMatchingFragments(prefix, itemText);
            if (fragments != null && !fragments.isEmpty()) {
                ArrayList list2 = ContainerUtil.newArrayList(fragments);
                return itemText.substring(((TextRange)list2.get(list2.size() - 1)).getEndOffset(), itemText.length());
            }
        }
        return "";
    }

    private void addInlay(String suffix, int caretOffset) {
        Inlay inlay = this.myLookup.getTopLevelEditor().getInlayModel().addInlineElement(caretOffset, LookupPreview.createGrayRenderer(suffix));
        if (inlay != null) {
            this.myInlays.add(inlay);
            Disposer.register((Disposable)this.myLookup, (Disposable)inlay);
        }
    }

    @NotNull
    private static EditorCustomElementRenderer createGrayRenderer(final String suffix) {
        EditorCustomElementRenderer editorCustomElementRenderer = new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Editor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/lookup/impl/LookupPreview$1", "calcWidthInPixels"));
                }
                return editor.getContentComponent().getFontMetrics(this.getFont(editor)).stringWidth(suffix);
            }

            public void paint(@NotNull Editor editor, @NotNull Graphics g2, @NotNull Rectangle r2) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/lookup/impl/LookupPreview$1", "paint"));
                }
                if (g2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/codeInsight/lookup/impl/LookupPreview$1", "paint"));
                }
                if (r2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/codeInsight/lookup/impl/LookupPreview$1", "paint"));
                }
                g2.setColor((Color)JBColor.GRAY);
                g2.setFont(this.getFont(editor));
                g2.drawString(suffix, r2.x, r2.y + ((EditorImpl)editor).getAscent());
            }

            private Font getFont(@NotNull Editor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/lookup/impl/LookupPreview$1", "getFont"));
                }
                return editor.getColorsScheme().getFont(EditorFontType.PLAIN);
            }
        };
        if (editorCustomElementRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupPreview", "createGrayRenderer"));
        }
        return editorCustomElementRenderer;
    }
}

