/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.impl.Advertiser;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBList;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LookupUi {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupUi");
    @NotNull
    private final LookupImpl myLookup;
    private final Advertiser myAdvertiser;
    private final JBList myList;
    private final Project myProject;
    private final ModalityState myModalityState;
    private final Alarm myHintAlarm;
    private final JLabel mySortingLabel;
    private final JScrollPane myScrollPane;
    private final AsyncProcessIcon myProcessIcon;
    private final JPanel myIconPanel;
    private final LookupLayeredPane myLayeredPane;
    private LookupHint myElementHint;
    private int myMaximumHeight;
    private Boolean myPositionedAbove;

    LookupUi(@NotNull LookupImpl lookup, Advertiser advertiser, JBList list2, Project project2) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/impl/LookupUi", "<init>"));
        }
        this.myHintAlarm = new Alarm();
        this.mySortingLabel = new JLabel();
        this.myProcessIcon = new AsyncProcessIcon("Completion progress");
        this.myIconPanel = new JPanel(new BorderLayout());
        this.myLayeredPane = new LookupLayeredPane();
        this.myElementHint = null;
        this.myMaximumHeight = Integer.MAX_VALUE;
        this.myPositionedAbove = null;
        this.myLookup = lookup;
        this.myAdvertiser = advertiser;
        this.myList = list2;
        this.myProject = project2;
        this.myIconPanel.setVisible(false);
        this.myIconPanel.setOpaque(false);
        this.myIconPanel.add((Component)this.myProcessIcon);
        JComponent adComponent = advertiser.getAdComponent();
        adComponent.setBorder(new EmptyBorder(0, 1, 1, 2 + AllIcons.Ide.LookupRelevance.getIconWidth()));
        this.myLayeredPane.mainPanel.add((Component)adComponent, "South");
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)lookup.getList(), (boolean)true);
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        ((Container)lookup.getComponent()).add((Component)((Object)this.myLayeredPane), "Center");
        this.fixMouseCheaters();
        this.myLayeredPane.mainPanel.add((Component)this.myScrollPane, "Center");
        this.mySortingLabel.setBorder(new LineBorder((Color)new JBColor(Color.LIGHT_GRAY, JBColor.background())));
        this.mySortingLabel.setOpaque(true);
        new ChangeLookupSorting().installOn(this.mySortingLabel);
        this.updateSorting();
        this.myModalityState = ModalityState.stateForComponent((Component)lookup.getTopLevelEditor().getComponent());
        this.addListeners();
        this.updateScrollbarVisibility();
        Disposer.register((Disposable)lookup, (Disposable)this.myProcessIcon);
        Disposer.register((Disposable)lookup, (Disposable)this.myHintAlarm);
    }

    private void addListeners() {
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (LookupUi.this.myLookup.isLookupDisposed()) {
                    return;
                }
                LookupUi.this.myHintAlarm.cancelAllRequests();
                LookupElement item = LookupUi.this.myLookup.getCurrentItem();
                if (item != null) {
                    LookupUi.this.updateHint(item);
                }
            }
        });
        final Alarm alarm = new Alarm((Disposable)this.myLookup);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e2) {
                if (((LookupUi)LookupUi.this).myLookup.myUpdating || LookupUi.this.myLookup.isLookupDisposed()) {
                    return;
                }
                alarm.addRequest(() -> LookupUi.this.myLookup.refreshUi(false, false), 300, LookupUi.this.myModalityState);
            }
        });
    }

    private void updateScrollbarVisibility() {
        boolean showSorting = this.myLookup.isCompletion() && this.myList.getModel().getSize() >= 3;
        this.mySortingLabel.setVisible(showSorting);
        this.myScrollPane.setVerticalScrollBarPolicy(showSorting ? 22 : 20);
    }

    private void updateHint(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/lookup/impl/LookupUi", "updateHint"));
        }
        this.myLookup.checkValid();
        if (this.myElementHint != null) {
            this.myLayeredPane.remove(this.myElementHint);
            this.myElementHint = null;
            JRootPane rootPane = ((JComponent)this.myLookup.getComponent()).getRootPane();
            if (rootPane != null) {
                rootPane.revalidate();
                rootPane.repaint();
            }
        }
        if (!item.isValid()) {
            return;
        }
        Collection<LookupElementAction> actions2 = this.myLookup.getActionsFor(item);
        if (!actions2.isEmpty()) {
            this.myHintAlarm.addRequest(() -> {
                if (!ShowHideIntentionIconLookupAction.shouldShowLookupHint() || ((CompletionExtender)this.myList.getExpandableItemsHandler()).isShowing()) {
                    return;
                }
                this.myElementHint = new LookupHint();
                this.myLayeredPane.add(this.myElementHint, 20, 0);
                this.myLayeredPane.layoutHint();
            }, 500, this.myModalityState);
        }
    }

    private void fixMouseCheaters() {
        this.myLookup.getComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                ActionCallback done2 = IdeFocusManager.getInstance((Project)LookupUi.this.myProject).requestFocus((Component)LookupUi.this.myLookup.getTopLevelEditor().getContentComponent(), true);
                IdeFocusManager.getInstance((Project)LookupUi.this.myProject).typeAheadUntil(done2);
                new Alarm((Disposable)LookupUi.this.myLookup).addRequest(() -> {
                    if (!done2.isDone()) {
                        done2.setDone();
                    }
                }, 300, LookupUi.this.myModalityState);
            }
        });
    }

    void setCalculating(boolean calculating) {
        Runnable setVisible = () -> this.myIconPanel.setVisible(this.myLookup.isCalculating());
        if (this.myLookup.isCalculating()) {
            new Alarm((Disposable)this.myLookup).addRequest(setVisible, 100, this.myModalityState);
        } else {
            setVisible.run();
        }
        if (calculating) {
            this.myProcessIcon.resume();
        } else {
            this.myProcessIcon.suspend();
        }
    }

    private void updateSorting() {
        boolean lexi = UISettings.getInstance().getSortLookupElementsLexicographically();
        this.mySortingLabel.setIcon(lexi ? AllIcons.Ide.LookupAlphanumeric : AllIcons.Ide.LookupRelevance);
        this.mySortingLabel.setToolTipText(lexi ? "Click to sort variants by relevance" : "Click to sort variants alphabetically");
        this.myLookup.resort(false);
    }

    void refreshUi(boolean selectionVisible, boolean itemsChanged, boolean reused, boolean onExplicitAction) {
        Editor editor = this.myLookup.getTopLevelEditor();
        if (editor.getComponent().getRootPane() == null || editor instanceof EditorWindow && !((EditorWindow)editor).isValid()) {
            return;
        }
        this.updateScrollbarVisibility();
        if (this.myLookup.myResizePending || itemsChanged) {
            this.myMaximumHeight = Integer.MAX_VALUE;
        }
        Rectangle rectangle = this.calculatePosition();
        this.myMaximumHeight = rectangle.height;
        if (this.myLookup.myResizePending || itemsChanged) {
            this.myLookup.myResizePending = false;
            this.myLookup.pack();
        }
        HintManagerImpl.updateLocation(this.myLookup, editor, rectangle.getLocation());
        if (reused || selectionVisible || onExplicitAction) {
            this.myLookup.ensureSelectionVisible(false);
        }
    }

    boolean isPositionedAboveCaret() {
        return this.myPositionedAbove != null && this.myPositionedAbove != false;
    }

    Rectangle calculatePosition() {
        JRootPane rootPane;
        Component lookupComponent = this.myLookup.getComponent();
        Dimension dim = ((JComponent)lookupComponent).getPreferredSize();
        int lookupStart = this.myLookup.getLookupStart();
        Editor editor = this.myLookup.getTopLevelEditor();
        if (lookupStart < 0 || lookupStart > editor.getDocument().getTextLength()) {
            LOG.error(lookupStart + "; offset=" + editor.getCaretModel().getOffset() + "; element=" + this.myLookup.getPsiElement());
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(lookupStart);
        Point location = editor.logicalPositionToXY(pos);
        location.y += editor.getLineHeight();
        location.x -= this.myLookup.myCellRenderer.getTextIndent();
        Window window = UIUtil.getWindow((Component)lookupComponent);
        if (window != null) {
            Point point = SwingUtilities.convertPoint(lookupComponent, 0, 0, window);
            location.x -= point.x;
        }
        SwingUtilities.convertPointToScreen(location, editor.getContentComponent());
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)location);
        if (!this.isPositionedAboveCaret()) {
            int shiftLow = screenRectangle.height - (location.y + dim.height);
            this.myPositionedAbove = shiftLow < 0 && shiftLow < location.y - dim.height && location.y >= dim.height;
        }
        if (this.isPositionedAboveCaret()) {
            location.y -= dim.height + editor.getLineHeight();
            if (pos.line == 0) {
                ++location.y;
            }
        }
        if (!screenRectangle.contains(location)) {
            location = ScreenUtil.findNearestPointOnBorder((Rectangle)screenRectangle, (Point)location);
        }
        if ((rootPane = editor.getComponent().getRootPane()) == null) {
            LOG.error("editor.disposed=" + editor.isDisposed() + "; lookup.disposed=" + this.myLookup.isLookupDisposed() + "; editorShowing=" + editor.getContentComponent().isShowing());
        }
        Rectangle candidate = new Rectangle(location, dim);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)candidate);
        SwingUtilities.convertPointFromScreen(location, rootPane.getLayeredPane());
        this.myMaximumHeight = candidate.height;
        return new Rectangle(location.x, location.y, dim.width, candidate.height);
    }

    private static class ScrollBottomBorder
    extends AbstractBorder {
        private final int myBottomOffset;

        ScrollBottomBorder(int bottomOffset) {
            this.myBottomOffset = bottomOffset;
        }

        @Override
        public Insets getBorderInsets(Component c2, Insets insets) {
            insets.set(0, 0, this.myBottomOffset, 0);
            return insets;
        }

        static void update(JScrollBar bar, int bottomOffset) {
            if (bar != null) {
                Border border = bar.getBorder();
                if (border instanceof ScrollBottomBorder) {
                    ScrollBottomBorder sbb = (ScrollBottomBorder)border;
                    if (bottomOffset != sbb.myBottomOffset) {
                        bar.setBorder(new ScrollBottomBorder(bottomOffset));
                    }
                } else if (bottomOffset != 0) {
                    bar.setBorder(new ScrollBottomBorder(bottomOffset));
                }
            }
        }
    }

    private class ChangeLookupSorting
    extends ClickListener {
        private ChangeLookupSorting() {
        }

        public boolean onClick(@NotNull MouseEvent e2, int clickCount) {
            if (e2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupUi$ChangeLookupSorting", "onClick"));
            }
            DataContext context2 = DataManager.getInstance().getDataContext((Component)LookupUi.this.mySortingLabel);
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(this.createSortingAction(true));
            group.add(this.createSortingAction(false));
            JBPopupFactory.getInstance().createActionGroupPopup("Change Sorting", (ActionGroup)group, context2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showInBestPositionFor(context2);
            return true;
        }

        private AnAction createSortingAction(boolean checked) {
            boolean currentSetting = UISettings.getInstance().getSortLookupElementsLexicographically();
            final boolean newSetting = checked == currentSetting;
            return new DumbAwareAction(newSetting ? "Sort lexicographically" : "Sort by relevance", null, checked ? PlatformIcons.CHECK_ICON : null){

                public void actionPerformed(AnActionEvent e2) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.changeSorting");
                    UISettings.getInstance().setSortLookupElementsLexicographically(newSetting);
                    LookupUi.this.updateSorting();
                }
            };
        }
    }

    private class LookupHint
    extends JLabel {
        private final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        private final Border ACTIVE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));

        private LookupHint() {
            this.setOpaque(false);
            this.setBorder(this.INACTIVE_BORDER);
            this.setIcon(AllIcons.Actions.IntentionBulb);
            String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
            if (acceleratorsText.length() > 0) {
                this.setToolTipText(CodeInsightBundle.message((String)"lightbulb.tooltip", (Object[])new Object[]{acceleratorsText}));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e2) {
                    LookupHint.this.setBorder(LookupHint.this.ACTIVE_BORDER);
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                    LookupHint.this.setBorder(LookupHint.this.INACTIVE_BORDER);
                }

                @Override
                public void mousePressed(MouseEvent e2) {
                    if (!e2.isPopupTrigger() && e2.getButton() == 1) {
                        LookupUi.this.myLookup.showElementActions();
                    }
                }
            });
        }
    }

    private class LookupLayeredPane
    extends JBLayeredPane {
        final JPanel mainPanel = new JPanel(new BorderLayout());

        private LookupLayeredPane() {
            this.add(this.mainPanel, 0, 0);
            this.add(LookupUi.this.myIconPanel, 42, 0);
            this.add(LookupUi.this.mySortingLabel, 10, 0);
            this.setLayout((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(@Nullable Container parent) {
                    int maxCellWidth = ((LookupUi)LookupUi.this).myLookup.myLookupTextWidth + ((LookupUi)LookupUi.this).myLookup.myCellRenderer.getTextIndent();
                    int scrollBarWidth = ((LookupUi)LookupUi.this).myScrollPane.getPreferredSize().width - ((LookupUi)LookupUi.this).myScrollPane.getViewport().getPreferredSize().width;
                    int listWidth = Math.min(scrollBarWidth + maxCellWidth, UISettings.getInstance().getMaxLookupWidth());
                    Dimension adSize = LookupUi.this.myAdvertiser.getAdComponent().getPreferredSize();
                    int panelHeight = ((LookupUi)LookupUi.this).myList.getPreferredScrollableViewportSize().height + adSize.height;
                    if (LookupUi.this.myList.getModel().getSize() > LookupUi.this.myList.getVisibleRowCount() && LookupUi.this.myList.getVisibleRowCount() >= 5) {
                        panelHeight -= LookupUi.this.myList.getFixedCellHeight() / 2;
                    }
                    int width = Math.max(listWidth, adSize.width);
                    width = Math.min(width, Registry.intValue((String)"ide.completion.max.width"));
                    int height = Math.min(panelHeight, LookupUi.this.myMaximumHeight);
                    return new Dimension(width, height);
                }

                public void layoutContainer(Container parent) {
                    Dimension size = LookupLayeredPane.this.getSize();
                    LookupLayeredPane.this.mainPanel.setSize(size);
                    LookupLayeredPane.this.mainPanel.validate();
                    if (!((LookupUi)LookupUi.this).myLookup.myResizePending) {
                        int listHeight;
                        Dimension preferredSize = this.preferredLayoutSize(null);
                        if (preferredSize.width != size.width) {
                            UISettings.getInstance().setMaxLookupWidth(Math.max(500, size.width));
                        }
                        if ((listHeight = LookupUi.this.myList.getLastVisibleIndex() - LookupUi.this.myList.getFirstVisibleIndex() + 1) != LookupUi.this.myList.getModel().getSize() && listHeight != LookupUi.this.myList.getVisibleRowCount() && preferredSize.height != size.height) {
                            UISettings.getInstance().setMaxLookupListHeight(Math.max(5, listHeight));
                        }
                    }
                    LookupUi.this.myList.setFixedCellWidth(LookupUi.this.myScrollPane.getViewport().getWidth());
                    LookupLayeredPane.this.layoutStatusIcons();
                    LookupLayeredPane.this.layoutHint();
                }
            });
        }

        private void layoutStatusIcons() {
            int adHeight = ((LookupUi)LookupUi.this).myAdvertiser.getAdComponent().getPreferredSize().height;
            int bottomOffset = adHeight > 0 || !LookupUi.this.mySortingLabel.isVisible() ? 0 : AllIcons.Ide.LookupRelevance.getIconHeight();
            JScrollBar vScrollBar = LookupUi.this.myScrollPane.getVerticalScrollBar();
            ScrollBottomBorder.update(vScrollBar, bottomOffset);
            Dimension iconSize = LookupUi.this.myProcessIcon.getPreferredSize();
            LookupUi.this.myIconPanel.setBounds(this.getWidth() - iconSize.width - (vScrollBar.isVisible() ? vScrollBar.getWidth() : 0), 0, iconSize.width, iconSize.height);
            Dimension sortSize = LookupUi.this.mySortingLabel.getPreferredSize();
            int sortWidth = vScrollBar.isVisible() ? vScrollBar.getWidth() : sortSize.width;
            int sortHeight = Math.max(sortSize.height, adHeight);
            LookupUi.this.mySortingLabel.setBounds(this.getWidth() - sortWidth, this.getHeight() - sortHeight, sortSize.width, sortHeight);
        }

        void layoutHint() {
            if (LookupUi.this.myElementHint != null && LookupUi.this.myLookup.getCurrentItem() != null) {
                Rectangle bounds = LookupUi.this.myLookup.getCurrentItemBounds();
                LookupUi.this.myElementHint.setSize(LookupUi.this.myElementHint.getPreferredSize());
                JScrollBar sb2 = LookupUi.this.myScrollPane.getVerticalScrollBar();
                int x2 = bounds.x + bounds.width - LookupUi.this.myElementHint.getWidth() + (sb2.isVisible() ? sb2.getWidth() : 0);
                x2 = Math.min(x2, this.getWidth() - LookupUi.this.myElementHint.getWidth());
                LookupUi.this.myElementHint.setLocation(new Point(x2, bounds.y));
            }
        }
    }
}

