/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtil {
    private NavigationUtil() {
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, String title) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, new DefaultPsiElementCellRenderer(), title);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, @NotNull PsiElementListCellRenderer<PsiElement> renderer, String title) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup((PsiElement[])elements, renderer, (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/navigation/NavigationUtil$1", "execute"));
                }
                Navigatable descriptor2 = EditSourceUtil.getDescriptor((PsiElement)element);
                if (descriptor2 != null && descriptor2.canNavigate()) {
                    descriptor2.navigate(true);
                }
                return true;
            }
        });
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, String title, @NotNull PsiElementProcessor<T> processor2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, renderer, (String)title, processor2, null);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, @Nullable String title, @NotNull PsiElementProcessor<T> processor2, @Nullable T selection) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        assert (elements.length > 0) : "Attempted to show a navigation popup with zero elements";
        JBList list2 = new JBList((Object[])elements);
        HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)list2);
        list2.setCellRenderer(renderer);
        list2.setFont(EditorUtil.getEditorFont());
        if (selection != null) {
            list2.setSelectedValue(selection, true);
        }
        Runnable runnable2 = () -> NavigationUtil.lambda$getPsiElementPopup$0((JList)list2, processor2);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list2);
        if (title != null) {
            builder.setTitle(title);
        }
        renderer.installSpeedSearch(builder, true);
        JBPopup popup2 = builder.setItemChoosenCallback(runnable2).createPopup();
        builder.getScrollPane().setBorder(null);
        builder.getScrollPane().setViewportBorder(null);
        NavigationUtil.hidePopupIfDumbModeStarts(popup2, elements[0].getProject());
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    public static void hidePopupIfDumbModeStarts(final @NotNull JBPopup popup2, @NotNull Project project2) {
        if (popup2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInsight/navigation/NavigationUtil", "hidePopupIfDumbModeStarts"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/NavigationUtil", "hidePopupIfDumbModeStarts"));
        }
        if (!DumbService.isDumb((Project)project2)) {
            project2.getMessageBus().connect((Disposable)popup2).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    popup2.cancel();
                }
            });
        }
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/navigation/NavigationUtil", "activateFileWithPsiElement"));
        }
        return NavigationUtil.activateFileWithPsiElement(elt, true);
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt, boolean searchForOpen) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/navigation/NavigationUtil", "activateFileWithPsiElement"));
        }
        return NavigationUtil.openFileWithPsiElement(elt, searchForOpen, true);
    }

    public static boolean openFileWithPsiElement(PsiElement element, boolean searchForOpen, boolean requestFocus2) {
        VirtualFile virtualFile;
        boolean openAsNative = false;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            openAsNative = ElementBase.isNativeFileType((FileType)virtualFile.getFileType());
        }
        if (searchForOpen) {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        } else {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)true);
        }
        if (openAsNative || !NavigationUtil.activatePsiElementIfOpen(element, searchForOpen, requestFocus2)) {
            NavigationItem navigationItem = (NavigationItem)element;
            if (!navigationItem.canNavigate()) {
                return false;
            }
            navigationItem.navigate(requestFocus2);
            return true;
        }
        element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        return false;
    }

    private static boolean activatePsiElementIfOpen(@NotNull PsiElement elt, boolean searchForOpen, boolean requestFocus2) {
        FileEditor[] editors;
        TextRange range;
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/navigation/NavigationUtil", "activatePsiElementIfOpen"));
        }
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file2 = (elt = elt.getNavigationElement()).getContainingFile();
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (!EditorHistoryManager.getInstance(elt.getProject()).hasBeenOpen(vFile)) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance((Project)elt.getProject());
        if (!fem.isFileOpen(vFile)) {
            fem.openFile(vFile, requestFocus2, searchForOpen);
        }
        if ((range = elt.getTextRange()) == null) {
            return false;
        }
        for (FileEditor editor : editors = fem.getEditors(vFile)) {
            Editor text2;
            int offset;
            if (!(editor instanceof TextEditor) || !range.containsOffset(offset = (text2 = ((TextEditor)editor).getEditor()).getCaretModel().getOffset())) continue;
            fem.openFile(vFile, requestFocus2, searchForOpen);
            return true;
        }
        return false;
    }

    public static TextAttributes patchAttributesColor(TextAttributes attributes, @NotNull TextRange range, @NotNull Editor editor) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/navigation/NavigationUtil", "patchAttributesColor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/NavigationUtil", "patchAttributesColor"));
        }
        if (attributes.getForegroundColor() == null && attributes.getEffectColor() == null) {
            return attributes;
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument(editor.getDocument(), editor.getProject(), false);
        if (model2 != null && !((MarkupModelEx)model2).processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter2 -> {
            TextAttributes textAttributes;
            if (highlighter2.isValid() && highlighter2.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE && (textAttributes = highlighter2.getTextAttributes()) != null) {
                Color color = textAttributes.getBackgroundColor();
                return color == null || color.getBlue() <= 128 || color.getRed() >= 128 || color.getGreen() >= 128;
            }
            return true;
        }))) {
            TextAttributes clone = attributes.clone();
            clone.setForegroundColor(Color.orange);
            clone.setEffectColor(Color.orange);
            return clone;
        }
        return attributes;
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items2, String title) {
        JBPopup jBPopup = NavigationUtil.getRelatedItemsPopup(items2, title, false);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getRelatedItemsPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items2, String title, boolean showContainingModules) {
        Object[] elements = new Object[items2.size()];
        HashMap<PsiElement, GotoRelatedItem> itemsMap = new HashMap<PsiElement, GotoRelatedItem>();
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            GotoRelatedItem item = items2.get(i2);
            elements[i2] = item.getElement() != null ? item.getElement() : item;
            itemsMap.put(item.getElement(), item);
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, itemsMap, title, showContainingModules, (Processor<Object>)((Processor)element -> {
            if (element instanceof PsiElement) {
                ((GotoRelatedItem)itemsMap.get(element)).navigate();
            } else {
                ((GotoRelatedItem)element).navigate();
            }
            return true;
        }));
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getRelatedItemsPopup"));
        }
        return jBPopup;
    }

    private static JBPopup getPsiElementPopup(Object[] elements, final Map<PsiElement, GotoRelatedItem> itemsMap, String title, final boolean showContainingModules, final Processor<Object> processor2) {
        final Ref hasMnemonic = Ref.create((Object)false);
        final DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){
            {
                this.setFocusBorderEnabled(false);
            }

            @Override
            public String getElementText(PsiElement element) {
                String customName = ((GotoRelatedItem)itemsMap.get(element)).getCustomName();
                return customName != null ? customName : super.getElementText(element);
            }

            @Override
            protected Icon getIcon(PsiElement element) {
                Icon customIcon = ((GotoRelatedItem)itemsMap.get(element)).getCustomIcon();
                return customIcon != null ? customIcon : super.getIcon(element);
            }

            @Override
            public String getContainerText(PsiElement element, String name) {
                String customContainerName = ((GotoRelatedItem)itemsMap.get(element)).getCustomContainerName();
                if (customContainerName != null) {
                    return customContainerName;
                }
                PsiFile file2 = element.getContainingFile();
                return file2 != null && !this.getElementText(element).equals(file2.getName()) ? "(" + file2.getName() + ")" : null;
            }

            @Override
            protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
                return showContainingModules ? super.getRightCellRenderer(value2) : null;
            }

            @Override
            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                GotoRelatedItem item = (GotoRelatedItem)value2;
                Color color = list2.getForeground();
                SimpleTextAttributes nameAttributes = new SimpleTextAttributes(0, color);
                String name = item.getCustomName();
                if (name == null) {
                    return false;
                }
                renderer.append(name, nameAttributes);
                renderer.setIcon(item.getCustomIcon());
                return true;
            }

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel component = (JPanel)super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                if (!((Boolean)hasMnemonic.get()).booleanValue()) {
                    return component;
                }
                JPanel panelWithMnemonic = new JPanel(new BorderLayout());
                int mnemonic = NavigationUtil.getMnemonic(value2, itemsMap);
                JLabel label = new JLabel("");
                if (mnemonic != -1) {
                    label.setText(mnemonic + ".");
                    label.setDisplayedMnemonicIndex(0);
                }
                label.setPreferredSize(new JLabel("8.").getPreferredSize());
                JComponent leftRenderer = (JComponent)component.getComponents()[0];
                component.remove(leftRenderer);
                panelWithMnemonic.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                panelWithMnemonic.setBackground(leftRenderer.getBackground());
                label.setBackground(leftRenderer.getBackground());
                panelWithMnemonic.add((Component)label, "West");
                panelWithMnemonic.add((Component)leftRenderer, "Center");
                component.add(panelWithMnemonic);
                return component;
            }
        };
        final ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<Object>(title, Arrays.asList(elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(Object value2) {
                if (value2 instanceof GotoRelatedItem) {
                    return ((GotoRelatedItem)value2).getCustomName();
                }
                PsiElement element = (PsiElement)value2;
                if (!element.isValid()) {
                    return "INVALID";
                }
                return renderer.getElementText(element) + " " + renderer.getContainerText(element, (String)null);
            }

            public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
                processor2.process(selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }
        }){};
        popup2.getList().setCellRenderer(new PopupListElementRenderer(popup2){
            Map<Object, String> separators;
            {
                super(x0);
                this.separators = new HashMap<Object, String>();
                ListModel model2 = popup2.getList().getModel();
                String current = null;
                boolean hasTitle = false;
                for (int i2 = 0; i2 < model2.getSize(); ++i2) {
                    Object element = model2.getElementAt(i2);
                    GotoRelatedItem item = (GotoRelatedItem)itemsMap.get(element);
                    if (item == null || StringUtil.equals(current, (CharSequence)item.getGroup())) continue;
                    current = item.getGroup();
                    this.separators.put(element, current);
                    if (hasTitle || StringUtil.isEmpty((String)current)) continue;
                    hasTitle = true;
                }
                if (!hasTitle) {
                    this.separators.remove(model2.getElementAt(0));
                }
            }

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = renderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                String separator = this.separators.get(value2);
                if (separator != null) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.add(component, "Center");
                    SeparatorWithText sep = new SeparatorWithText(){

                        protected void paintComponent(Graphics g2) {
                            g2.setColor((Color)new JBColor(Color.WHITE, UIUtil.getSeparatorColor()));
                            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paintComponent(g2);
                        }
                    };
                    sep.setCaption(separator);
                    panel2.add((Component)sep, "North");
                    return panel2;
                }
                return component;
            }
        });
        popup2.setMinimumSize(new Dimension(200, -1));
        for (Object item : elements) {
            int mnemonic = NavigationUtil.getMnemonic(item, itemsMap);
            if (mnemonic == -1) continue;
            Action action2 = NavigationUtil.createNumberAction(mnemonic, popup2, itemsMap, processor2);
            popup2.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke(String.valueOf(mnemonic)), action2);
            popup2.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke("NUMPAD" + String.valueOf(mnemonic)), action2);
            hasMnemonic.set((Object)true);
        }
        return popup2;
    }

    private static Action createNumberAction(final int mnemonic, final ListPopupImpl listPopup, final Map<PsiElement, GotoRelatedItem> itemsMap, final Processor<Object> processor2) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                for (Object item : listPopup.getListStep().getValues()) {
                    if (NavigationUtil.getMnemonic(item, itemsMap) != mnemonic) continue;
                    listPopup.setFinalRunnable(() -> processor2.process(item));
                    listPopup.closeOk(null);
                }
            }
        };
    }

    private static int getMnemonic(Object item, Map<PsiElement, GotoRelatedItem> itemsMap) {
        return (item instanceof GotoRelatedItem ? (GotoRelatedItem)item : itemsMap.get((PsiElement)item)).getMnemonic();
    }

    @NotNull
    public static List<GotoRelatedItem> collectRelatedItems(@NotNull PsiElement contextElement, @Nullable DataContext dataContext) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInsight/navigation/NavigationUtil", "collectRelatedItems"));
        }
        LinkedHashSet items2 = ContainerUtil.newLinkedHashSet();
        for (GotoRelatedProvider provider : (GotoRelatedProvider[])Extensions.getExtensions((ExtensionPointName)GotoRelatedProvider.EP_NAME)) {
            items2.addAll(provider.getItems(contextElement));
            if (dataContext == null) continue;
            items2.addAll(provider.getItems(dataContext));
        }
        GotoRelatedItem[] result2 = items2.toArray(new GotoRelatedItem[items2.size()]);
        Arrays.sort(result2, (i1, i2) -> {
            String o1 = i1.getGroup();
            String o2 = i2.getGroup();
            return StringUtil.isEmpty((String)o1) ? 1 : (StringUtil.isEmpty((String)o2) ? -1 : o1.compareTo(o2));
        });
        List<GotoRelatedItem> list2 = Arrays.asList(result2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "collectRelatedItems"));
        }
        return list2;
    }

    private static /* synthetic */ void lambda$getPsiElementPopup$0(JList list2, @NotNull PsiElementProcessor processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/navigation/NavigationUtil", "lambda$getPsiElementPopup$0"));
        }
        int[] ids = list2.getSelectedIndices();
        if (ids == null || ids.length == 0) {
            return;
        }
        for (Object element : list2.getSelectedValues()) {
            if (element == null) continue;
            processor2.execute((PsiElement)element);
        }
    }
}

