/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.PreviewHintComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorPreviewComponent
extends JComponent
implements PreviewHintComponent {
    @NotNull
    private final Color myColor;

    public ColorPreviewComponent(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/preview/ColorPreviewComponent", "<init>"));
        }
        this.myColor = color;
        this.setOpaque(true);
    }

    @Override
    public void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        Rectangle r2 = this.getBounds();
        g22.setPaint(this.myColor);
        g22.fillRect(1, 1, r2.width - 2, r2.height - 2);
        g22.setPaint(Color.BLACK);
        g22.drawRect(0, 0, r2.width - 1, r2.height - 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(70, 25);
    }

    @Override
    public boolean isEqualTo(@Nullable PreviewHintComponent other) {
        return other instanceof ColorPreviewComponent && this.myColor.equals(((ColorPreviewComponent)other).myColor);
    }
}

