/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.NumberToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.StringLiteralToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingTokens;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetLexer {
    private static final String DELIMS = ">^+*|()[]{}.#,='\" \u0000";

    @Nullable
    public List<ZenCodingToken> lex(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/EmmetLexer", "lex"));
        }
        text2 = text2 + '\u0000';
        ArrayList<ZenCodingToken> result2 = new ArrayList<ZenCodingToken>();
        boolean inQuotes = false;
        boolean inApostrophes = false;
        int bracesStack = 0;
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c2 = text2.charAt(i2);
            if (inQuotes) {
                builder.append(c2);
                if (c2 != '\"') continue;
                inQuotes = false;
                result2.add(new StringLiteralToken(builder.toString()));
                builder = new StringBuilder();
                continue;
            }
            if (inApostrophes) {
                builder.append(c2);
                if (c2 != '\'') continue;
                inApostrophes = false;
                result2.add(new StringLiteralToken(builder.toString()));
                builder = new StringBuilder();
                continue;
            }
            if (bracesStack > 0) {
                builder.append(c2);
                if (c2 == '}') {
                    if (--bracesStack != 0) continue;
                    result2.add(new TextToken(builder.toString()));
                    builder = new StringBuilder();
                    continue;
                }
                if (c2 != '{') continue;
                ++bracesStack;
                continue;
            }
            if (DELIMS.indexOf(c2) < 0) {
                builder.append(c2);
                continue;
            }
            if (c2 == '+' && (i2 == text2.length() - 2 || text2.charAt(i2 + 1) == ')')) {
                builder.append(c2);
                continue;
            }
            if (builder.length() > 0) {
                String tokenText = builder.toString();
                int n2 = StringUtil.parseInt((String)tokenText, (int)-1);
                if (!StringUtil.startsWithChar((CharSequence)tokenText, (char)'0') && n2 >= 0) {
                    result2.add(new NumberToken(n2));
                } else {
                    result2.add(new IdentifierToken(tokenText));
                }
                builder = new StringBuilder();
            }
            if (c2 == '\"') {
                inQuotes = true;
                builder.append(c2);
                continue;
            }
            if (c2 == '\'') {
                inApostrophes = true;
                builder.append(c2);
                continue;
            }
            if (c2 == '{') {
                bracesStack = 1;
                builder.append(c2);
                continue;
            }
            if (c2 == '(') {
                result2.add(ZenCodingTokens.OPENING_R_BRACKET);
                continue;
            }
            if (c2 == ')') {
                result2.add(ZenCodingTokens.CLOSING_R_BRACKET);
                continue;
            }
            if (c2 == '[') {
                result2.add(ZenCodingTokens.OPENING_SQ_BRACKET);
                continue;
            }
            if (c2 == ']') {
                result2.add(ZenCodingTokens.CLOSING_SQ_BRACKET);
                continue;
            }
            if (c2 == '=') {
                result2.add(ZenCodingTokens.EQ);
                continue;
            }
            if (c2 == '.') {
                result2.add(ZenCodingTokens.DOT);
                continue;
            }
            if (c2 == '#') {
                result2.add(ZenCodingTokens.SHARP);
                continue;
            }
            if (c2 == ',') {
                result2.add(ZenCodingTokens.COMMA);
                continue;
            }
            if (c2 == ' ') {
                result2.add(ZenCodingTokens.SPACE);
                continue;
            }
            if (c2 == '|') {
                result2.add(ZenCodingTokens.PIPE);
                continue;
            }
            if (c2 == '\u0000') continue;
            result2.add(new OperationToken(c2));
        }
        if (bracesStack != 0 || inQuotes || inApostrophes) {
            return null;
        }
        return result2;
    }
}

