/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZenCodingGenerator {
    public static final ExtensionPointName<ZenCodingGenerator> EP_NAME = new ExtensionPointName("com.intellij.xml.zenCodingGenerator");

    public abstract TemplateImpl generateTemplate(@NotNull TemplateToken var1, boolean var2, @NotNull PsiElement var3);

    @Nullable
    public TemplateImpl createTemplateByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "createTemplateByKey"));
        }
        return null;
    }

    public abstract boolean isMyContext(@NotNull PsiElement var1, boolean var2);

    @Nullable
    public String getSuffix() {
        return null;
    }

    public abstract boolean isAppliedByDefault(@NotNull PsiElement var1);

    public abstract boolean isEnabled();

    public static ZenCodingGenerator[] getInstances() {
        return (ZenCodingGenerator[])EP_NAME.getExtensions();
    }

    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "computeTemplateKey"));
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        int startOffset = editor.getDocument().getLineStartOffset(editor.getCaretModel().getLogicalPosition().line);
        String key = this.computeKey(editor.getDocument().getCharsSequence().subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key) && ZenCodingTemplate.checkTemplateKey(key, callback, this) ? key : null;
    }

    @Nullable
    protected String computeKey(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "computeKey"));
        }
        int currentOffset = text2.length();
        int groupCount = 0;
        int bracketCount = 0;
        int textCount = 0;
        while (currentOffset > 0) {
            char c2;
            if ((c2 = text2.charAt(--currentOffset)) == ']') {
                ++bracketCount;
                continue;
            }
            if (c2 == '[') {
                if (bracketCount == 0) {
                    ++currentOffset;
                    break;
                }
                --bracketCount;
                continue;
            }
            if (c2 == '}') {
                ++textCount;
                continue;
            }
            if (c2 == '{') {
                if (textCount == 0) {
                    ++currentOffset;
                    break;
                }
                --textCount;
                continue;
            }
            if (c2 == ')') {
                ++groupCount;
                continue;
            }
            if (c2 == '(') {
                if (groupCount == 0) {
                    ++currentOffset;
                    break;
                }
                --groupCount;
                continue;
            }
            if (bracketCount > 0 || textCount > 0 || this.isAllowedChar(c2)) continue;
            ++currentOffset;
            break;
        }
        return groupCount == 0 && textCount == 0 && bracketCount == 0 && currentOffset >= 0 && currentOffset < text2.length() ? text2.subSequence(currentOffset, text2.length()).toString().replaceFirst("^[*+>^]+", "") : null;
    }

    protected boolean isAllowedChar(char c2) {
        return Character.isDigit(c2) || Character.isLetter(c2) || StringUtil.containsChar((String)"/>+^[](){}#.*:$-_!@|%", (char)c2);
    }

    @NotNull
    public EmmetParser createParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        XmlEmmetParser xmlEmmetParser = new XmlEmmetParser(tokens, callback, generator, surroundWithTemplate);
        if (xmlEmmetParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "createParser"));
        }
        return xmlEmmetParser;
    }

    @Nullable
    public Configurable createConfigurable() {
        return null;
    }

    public boolean hasCompletionItem() {
        return false;
    }

    public boolean isHtml(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/generators/ZenCodingGenerator", "isHtml"));
        }
        return false;
    }

    public void disableEmmet() {
    }
}

