/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;

public class InvokeTemplateAction
extends AnAction {
    private final TemplateImpl myTemplate;
    private final Editor myEditor;
    private final Project myProject;

    public InvokeTemplateAction(TemplateImpl template, Editor editor, Project project2, Set<Character> usedMnemonicsSet) {
        super(InvokeTemplateAction.extractMnemonic(template.getKey(), usedMnemonicsSet) + (StringUtil.isEmptyOrSpaces((String)template.getDescription()) ? "" : ". " + template.getDescription()));
        this.myTemplate = template;
        this.myProject = project2;
        this.myEditor = editor;
    }

    public static String extractMnemonic(String caption, Set<Character> usedMnemonics) {
        if (StringUtil.isEmpty((String)caption)) {
            return "";
        }
        for (int i2 = 0; i2 < caption.length(); ++i2) {
            char c2 = caption.charAt(i2);
            if (!usedMnemonics.add(Character.valueOf(Character.toUpperCase(c2)))) continue;
            return caption.substring(0, i2) + '\u001b' + caption.substring(i2);
        }
        return caption + " ";
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public void actionPerformed(AnActionEvent e2) {
        this.perform();
    }

    public void perform() {
        final Document document = this.myEditor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(new VirtualFile[]{file2});
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.myEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                if (InvokeTemplateAction.this.myEditor.getSelectionModel().hasSelection() && InvokeTemplateAction.this.myTemplate.isToReformat()) {
                    int offset;
                    int selectionEnd = InvokeTemplateAction.this.myEditor.getSelectionModel().getSelectionEnd();
                    int lineEnd = document.getLineEndOffset(document.getLineNumber(offset));
                    for (offset = InvokeTemplateAction.this.myEditor.getSelectionModel().getSelectionStart(); offset < lineEnd && offset < selectionEnd && (document.getCharsSequence().charAt(offset) == ' ' || document.getCharsSequence().charAt(offset) == '\t'); ++offset) {
                    }
                    if (selectionEnd == document.getLineStartOffset(document.getLineNumber(selectionEnd))) {
                        --selectionEnd;
                    }
                    if (offset < lineEnd && offset < selectionEnd) {
                        InvokeTemplateAction.this.myEditor.getSelectionModel().setSelection(offset, selectionEnd);
                    }
                }
                String selectionString = InvokeTemplateAction.this.myEditor.getSelectionModel().getSelectedText();
                TemplateManager.getInstance(InvokeTemplateAction.this.myProject).startTemplate(InvokeTemplateAction.this.myEditor, selectionString, InvokeTemplateAction.this.myTemplate);
            }
        }), "Wrap with template", (Object)("Wrap with template " + this.myTemplate.getKey()));
    }
}

