/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class LiveTemplateLookupElementImpl
extends LiveTemplateLookupElement {
    private final TemplateImpl myTemplate;

    public LiveTemplateLookupElementImpl(@NotNull TemplateImpl template, boolean sudden) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElementImpl", "<init>"));
        }
        super(template.getKey(), StringUtil.notNullize((String)template.getDescription()), sudden, LiveTemplateCompletionContributor.shouldShowAllTemplates());
        this.myTemplate = template;
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string2 = this.myTemplate.getKey();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElementImpl", "getLookupString"));
        }
        return string2;
    }

    @NotNull
    public TemplateImpl getTemplate() {
        TemplateImpl templateImpl = this.myTemplate;
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElementImpl", "getTemplate"));
        }
        return templateImpl;
    }

    @Override
    public char getTemplateShortcut() {
        return TemplateSettings.getInstance().getShortcutChar(this.myTemplate);
    }

    public void handleInsert(InsertionContext context2) {
        LiveTemplateLookupElementImpl.startTemplate(context2, this.myTemplate);
    }

    public static void startTemplate(InsertionContext context2, @NotNull Template template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/LiveTemplateLookupElementImpl", "startTemplate"));
        }
        context2.getDocument().deleteString(context2.getStartOffset(), context2.getTailOffset());
        context2.setAddCompletionChar(false);
        TemplateManager.getInstance(context2.getProject()).startTemplate(context2.getEditor(), template);
    }
}

