/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiveTemplatesOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    public String getId() {
        return "templates";
    }

    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project2) {
        TemplateSettings settings = TemplateSettings.getInstance();
        if (settings == null) {
            List<BooleanOptionDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplatesOptionsTopHitProvider", "getOptions"));
            }
            return list2;
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (TemplateGroup group : settings.getTemplateGroups()) {
            for (TemplateImpl element : group.getElements()) {
                options.add(new Option(element));
            }
        }
        Collection<BooleanOptionDescription> collection = Collections.unmodifiableCollection(options);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplatesOptionsTopHitProvider", "getOptions"));
        }
        return collection;
    }

    private static final class Option
    extends BooleanOptionDescription {
        private final TemplateImpl myElement;

        private Option(TemplateImpl element) {
            super(Option.getOptionName(element), "editing.templates");
            this.myElement = element;
        }

        public boolean isOptionEnabled() {
            return !this.myElement.isDeactivated();
        }

        public void setOptionState(boolean enabled) {
            this.myElement.setDeactivated(!enabled);
        }

        private static String getOptionName(TemplateImpl element) {
            StringBuilder sb2 = new StringBuilder().append(element.getGroupName()).append(": ").append(element.getKey());
            String description = element.getDescription();
            if (description != null) {
                sb2.append(" (").append(description).append(")");
            }
            return sb2.toString();
        }
    }
}

