/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MacroCallNode
extends Expression {
    private final Macro myMacro;
    private final ArrayList<Expression> myParameters;

    public MacroCallNode(@NotNull Macro macro2) {
        if (macro2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/codeInsight/template/impl/MacroCallNode", "<init>"));
        }
        this.myParameters = new ArrayList();
        this.myMacro = macro2;
    }

    public void addParameter(Expression node) {
        this.myParameters.add(node);
    }

    public Macro getMacro() {
        return this.myMacro;
    }

    public Result calculateResult(ExpressionContext context2) {
        Expression[] parameters = this.myParameters.toArray(new Expression[this.myParameters.size()]);
        return this.getMacro().calculateResult(parameters, context2);
    }

    public Result calculateQuickResult(ExpressionContext context2) {
        Expression[] parameters = this.myParameters.toArray(new Expression[this.myParameters.size()]);
        return this.getMacro().calculateQuickResult(parameters, context2);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context2) {
        Expression[] parameters = this.myParameters.toArray(new Expression[this.myParameters.size()]);
        return this.getMacro().calculateLookupItems(parameters, context2);
    }

    public Expression[] getParameters() {
        return this.myParameters.toArray(new Expression[this.myParameters.size()]);
    }
}

