/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.MacroLexer;
import com.intellij.codeInsight.template.impl.MacroTokenType;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
public class MacroParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.MacroParser");

    @NotNull
    public static Expression parse(@Nullable String expression) {
        if (StringUtil.isEmpty((String)expression)) {
            ConstantNode constantNode = new ConstantNode("");
            if (constantNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/MacroParser", "parse"));
            }
            return constantNode;
        }
        MacroLexer lexer = new MacroLexer();
        lexer.start(expression);
        MacroParser.skipWhitespaces((Lexer)lexer);
        Expression expression2 = MacroParser.parseMacro((Lexer)lexer, expression);
        if (expression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/MacroParser", "parse"));
        }
        return expression2;
    }

    private static void advance(Lexer lexer) {
        lexer.advance();
        MacroParser.skipWhitespaces(lexer);
    }

    private static void skipWhitespaces(Lexer lexer) {
        while (lexer.getTokenType() == MacroTokenType.WHITE_SPACE) {
            lexer.advance();
        }
    }

    private static String getString(Lexer lexer, String expression) {
        return expression.substring(lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private static Expression parseMacro(Lexer lexer, String expression) {
        IElementType tokenType = lexer.getTokenType();
        String token = MacroParser.getString(lexer, expression);
        if (tokenType == MacroTokenType.STRING_LITERAL) {
            MacroParser.advance(lexer);
            return new ConstantNode(MacroParser.parseStringLiteral(token));
        }
        if (tokenType != MacroTokenType.IDENTIFIER) {
            LOG.info("Bad macro syntax: Not identifier: " + token);
            MacroParser.advance(lexer);
            return new ConstantNode("");
        }
        List<Macro> macros = MacroFactory.getMacros(token);
        if (macros.isEmpty()) {
            return MacroParser.parseVariable(lexer, expression);
        }
        MacroParser.advance(lexer);
        MacroCallNode macroCallNode = new MacroCallNode(macros.get(0));
        if (lexer.getTokenType() == null) {
            return macroCallNode;
        }
        if (lexer.getTokenType() != MacroTokenType.LPAREN) {
            return macroCallNode;
        }
        MacroParser.advance(lexer);
        MacroParser.parseParameters(macroCallNode, lexer, expression);
        if (lexer.getTokenType() != MacroTokenType.RPAREN) {
            LOG.info("Bad macro syntax: ) expected: " + expression);
        }
        MacroParser.advance(lexer);
        return macroCallNode;
    }

    private static String parseStringLiteral(String token) {
        StringBuilder sb2 = new StringBuilder(token.length() - 2);
        for (int i2 = 1; i2 < token.length() - 1; ++i2) {
            char c2 = token.charAt(i2);
            if (c2 == '\\') {
                if ((c2 = token.charAt(++i2)) == 'n') {
                    sb2.append('\n');
                    continue;
                }
                if (c2 == 't') {
                    sb2.append('\t');
                    continue;
                }
                if (c2 == 'f') {
                    sb2.append('\f');
                    continue;
                }
                sb2.append(c2);
                continue;
            }
            sb2.append(c2);
        }
        return sb2.toString();
    }

    private static void parseParameters(MacroCallNode macroCallNode, Lexer lexer, String expression) {
        if (lexer.getTokenType() != MacroTokenType.RPAREN) {
            while (lexer.getTokenType() != null) {
                Expression node = MacroParser.parseMacro(lexer, expression);
                macroCallNode.addParameter(node);
                if (lexer.getTokenType() != MacroTokenType.COMMA) break;
                MacroParser.advance(lexer);
            }
        }
    }

    private static Expression parseVariable(Lexer lexer, String expression) {
        String variableName = MacroParser.getString(lexer, expression);
        MacroParser.advance(lexer);
        if (lexer.getTokenType() == null) {
            if ("END".equals(variableName)) {
                return new EmptyNode();
            }
            return new VariableNode(variableName, null);
        }
        if (lexer.getTokenType() != MacroTokenType.EQ) {
            return new VariableNode(variableName, null);
        }
        MacroParser.advance(lexer);
        Expression node = MacroParser.parseMacro(lexer, expression);
        return new VariableNode(variableName, node);
    }
}

