/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class TemplateExpandShortcutPanel
extends JPanel {
    private final JComboBox myExpandByCombo;
    private final HyperlinkLabel myOpenKeymapLabel;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);
    private static final String CUSTOM = CodeInsightBundle.message((String)"template.shortcut.custom", (Object[])new Object[0]);

    public TemplateExpandShortcutPanel(@NotNull String label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/codeInsight/template/impl/TemplateExpandShortcutPanel", "<init>"));
        }
        super(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        this.add((Component)new JLabel(label), gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.insets = new Insets(0, 4, 0, 0);
        this.myExpandByCombo = new ComboBox();
        this.add((Component)this.myExpandByCombo, gbConstraints);
        this.myOpenKeymapLabel = new HyperlinkLabel("Change");
        gbConstraints.gridx = 2;
        this.add((Component)this.myOpenKeymapLabel, gbConstraints);
        gbConstraints.gridx = 3;
        gbConstraints.weightx = 1.0;
        this.add((Component)new JPanel(), gbConstraints);
        this.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.myExpandByCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TemplateExpandShortcutPanel.this.myOpenKeymapLabel.setVisible(TemplateExpandShortcutPanel.this.myExpandByCombo.getSelectedItem() == CUSTOM);
            }
        });
        for (String s2 : (String[])ContainerUtil.ar((Object[])new String[]{SPACE, TAB, ENTER, CUSTOM})) {
            this.myExpandByCombo.addItem(s2);
        }
        this.myExpandByCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                if (value2 == CUSTOM) {
                    Shortcut[] shortcuts = this.getCurrentCustomShortcuts();
                    String shortcutText = shortcuts.length == 0 ? "" : KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
                    this.setText(StringUtil.isEmpty((String)shortcutText) ? "Custom..." : "Custom (" + shortcutText + ")");
                }
            }

            private Shortcut[] getCurrentCustomShortcuts() {
                Shortcut[] shortcuts;
                Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)TemplateExpandShortcutPanel.this.myOpenKeymapLabel));
                KeymapPanel keymapPanel = allSettings == null ? null : allSettings.find(KeymapPanel.class);
                Shortcut[] shortcutArray = shortcuts = keymapPanel == null ? null : keymapPanel.getCurrentShortcuts("ExpandLiveTemplateCustom");
                if (shortcuts == null) {
                    Shortcut[] shortcutArray2;
                    KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("ExpandLiveTemplateCustom");
                    if (shortcut == null) {
                        shortcutArray2 = Shortcut.EMPTY_ARRAY;
                    } else {
                        Shortcut[] shortcutArray3 = new Shortcut[1];
                        shortcutArray2 = shortcutArray3;
                        shortcutArray3[0] = shortcut;
                    }
                    shortcuts = shortcutArray2;
                }
                return shortcuts;
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.isConfigurableOpenEvent(evt)) {
                    TemplateExpandShortcutPanel.this.resizeComboToFitCustomShortcut();
                }
            }

            private boolean isConfigurableOpenEvent(PropertyChangeEvent evt) {
                return evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null;
            }
        });
        this.myOpenKeymapLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e2) {
                KeymapPanel keymapPanel;
                Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)TemplateExpandShortcutPanel.this.myOpenKeymapLabel));
                KeymapPanel keymapPanel2 = keymapPanel = allSettings == null ? new KeymapPanel() : allSettings.find(KeymapPanel.class);
                if (keymapPanel == null) {
                    return;
                }
                Runnable selectAction = () -> keymapPanel.selectAction("ExpandLiveTemplateCustom");
                if (allSettings != null) {
                    allSettings.select((Configurable)keymapPanel).doWhenDone(selectAction);
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)TemplateExpandShortcutPanel.this.myOpenKeymapLabel, (Configurable)keymapPanel, selectAction);
                    TemplateExpandShortcutPanel.this.resizeComboToFitCustomShortcut();
                }
            }
        });
    }

    public String getSelectedString() {
        return (String)this.myExpandByCombo.getSelectedItem();
    }

    public void setSelectedChar(char ch) {
        this.myExpandByCombo.setSelectedItem(ch == 'C' ? CUSTOM : (ch == '\t' ? TAB : (ch == '\n' ? ENTER : SPACE)));
    }

    public char getSelectedChar() {
        Object selectedItem = this.myExpandByCombo.getSelectedItem();
        if (TAB.equals(selectedItem)) {
            return '\t';
        }
        if (ENTER.equals(selectedItem)) {
            return '\n';
        }
        if (SPACE.equals(selectedItem)) {
            return ' ';
        }
        return 'C';
    }

    private void resizeComboToFitCustomShortcut() {
        this.myExpandByCombo.setPrototypeDisplayValue(null);
        this.myExpandByCombo.setPrototypeDisplayValue(CUSTOM);
        this.myExpandByCombo.revalidate();
        this.myExpandByCombo.repaint();
    }
}

