/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateManagerImpl
extends TemplateManager
implements Disposable {
    private static final TemplateContextType[] ourContextTypes = (TemplateContextType[])Extensions.getExtensions((ExtensionPointName)TemplateContextType.EP_NAME);
    private final Project myProject;
    private boolean myTemplateTesting;
    private static final Key<TemplateState> TEMPLATE_STATE_KEY = Key.create((String)"TEMPLATE_STATE_KEY");
    private static final OffsetKey START_OFFSET = OffsetKey.create((String)"start", (boolean)false);
    private static final OffsetKey END_OFFSET = OffsetKey.create((String)"end", (boolean)true);

    public TemplateManagerImpl(Project project2) {
        this.myProject = project2;
        EditorFactoryAdapter myEditorFactoryListener = new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/TemplateManagerImpl$1", "editorReleased"));
                }
                Editor editor = event.getEditor();
                if (editor.getProject() != null && editor.getProject() != TemplateManagerImpl.this.myProject) {
                    return;
                }
                if (TemplateManagerImpl.this.myProject.isDisposed() || !TemplateManagerImpl.this.myProject.isOpen()) {
                    return;
                }
                TemplateState state = TemplateManagerImpl.getTemplateState(editor);
                if (state != null) {
                    state.gotoEnd();
                }
                TemplateManagerImpl.clearTemplateState(editor);
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener, (Disposable)this.myProject);
    }

    public void dispose() {
    }

    @Deprecated
    public void setTemplateTesting(boolean templateTesting) {
        this.myTemplateTesting = templateTesting;
    }

    public static void setTemplateTesting(Project project2, Disposable parentDisposable) {
        final TemplateManagerImpl instance2 = (TemplateManagerImpl)TemplateManagerImpl.getInstance(project2);
        instance2.myTemplateTesting = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance2.myTemplateTesting = false;
            }
        });
    }

    private static void disposeState(@NotNull TemplateState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "disposeState"));
        }
        Disposer.dispose((Disposable)state);
    }

    @Override
    public Template createTemplate(@NotNull String key, String group) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "createTemplate"));
        }
        return new TemplateImpl(key, group);
    }

    @Override
    public Template createTemplate(@NotNull String key, String group, String text2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "createTemplate"));
        }
        return new TemplateImpl(key, text2, group);
    }

    @Nullable
    public static TemplateState getTemplateState(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "getTemplateState"));
        }
        TemplateState templateState = (TemplateState)editor.getUserData(TEMPLATE_STATE_KEY);
        if (templateState != null && templateState.isDisposed()) {
            editor.putUserData(TEMPLATE_STATE_KEY, null);
            return null;
        }
        return templateState;
    }

    static void clearTemplateState(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "clearTemplateState"));
        }
        TemplateState prevState = TemplateManagerImpl.getTemplateState(editor);
        if (prevState != null) {
            TemplateManagerImpl.disposeState(prevState);
        }
        editor.putUserData(TEMPLATE_STATE_KEY, null);
    }

    private TemplateState initTemplateState(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "initTemplateState"));
        }
        TemplateManagerImpl.clearTemplateState(editor);
        TemplateState state = new TemplateState(this.myProject, editor);
        Disposer.register((Disposable)this, (Disposable)state);
        editor.putUserData(TEMPLATE_STATE_KEY, (Object)state);
        return state;
    }

    @Override
    public boolean startTemplate(@NotNull Editor editor, char shortcutChar) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        Runnable runnable2 = this.prepareTemplate(editor, shortcutChar, null);
        if (runnable2 != null) {
            if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), this.myProject)) {
                return false;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)runnable2);
        }
        return runnable2 != null;
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        this.startTemplate(editor, template, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, String selectionString, @NotNull Template template) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        this.startTemplate(editor, selectionString, template, true, null, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener2, PairProcessor<String, String> processor2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        this.startTemplate(editor, null, template, true, listener2, processor2, null);
    }

    private void startTemplate(Editor editor, String selectionString, Template template, boolean inSeparateCommand, TemplateEditingListener listener2, PairProcessor<String, String> processor2, Map<String, String> predefinedVarValues) {
        TemplateState templateState = this.initTemplateState(editor);
        templateState.getProperties().put(ExpressionContext.SELECTION, selectionString);
        if (listener2 != null) {
            templateState.addTemplateStateListener(listener2);
        }
        Runnable r2 = () -> {
            if (selectionString != null) {
                ApplicationManager.getApplication().runWriteAction(() -> EditorModificationUtil.deleteSelectedText((Editor)editor));
            } else {
                editor.getSelectionModel().removeSelection();
            }
            templateState.start((TemplateImpl)template, processor2, predefinedVarValues);
        };
        if (inSeparateCommand) {
            CommandProcessor.getInstance().executeCommand(this.myProject, r2, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
        } else {
            r2.run();
        }
        if (this.shouldSkipInTests() && !templateState.isFinished()) {
            templateState.gotoEnd(false);
        }
    }

    public boolean shouldSkipInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && !this.myTemplateTesting;
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        this.startTemplate(editor, null, template, true, listener2, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, boolean inSeparateCommand, Map<String, String> predefinedVarValues, TemplateEditingListener listener2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "startTemplate"));
        }
        this.startTemplate(editor, null, template, inSeparateCommand, listener2, null, predefinedVarValues);
    }

    private static int passArgumentBack(CharSequence text2, int caretOffset) {
        char c2;
        int i2;
        for (i2 = caretOffset - 1; i2 >= 0 && !TemplateManagerImpl.isDelimiter(c2 = text2.charAt(i2)); --i2) {
        }
        return i2 + 1;
    }

    private static boolean isDelimiter(char c2) {
        return !Character.isJavaIdentifierPart(c2);
    }

    private static <T, U> void addToMap(@NotNull Map<T, U> map2, @NotNull Collection<? extends T> keys, U value2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "addToMap"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "addToMap"));
        }
        for (T key : keys) {
            map2.put(key, value2);
        }
    }

    private static boolean containsTemplateStartingBefore(Map<TemplateImpl, String> template2argument, int offset, int caretOffset, CharSequence text2) {
        for (TemplateImpl template : template2argument.keySet()) {
            String argument;
            int templateStart = TemplateManagerImpl.getTemplateStart(template, argument = template2argument.get(template), caretOffset, text2);
            if (templateStart >= offset) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Runnable prepareTemplate(Editor editor, char shortcutChar, @Nullable PairProcessor<String, String> processor2) {
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
        if (file2 == null) {
            return null;
        }
        Map<TemplateImpl, String> template2argument = this.findMatchingTemplates(file2, editor, Character.valueOf(shortcutChar), TemplateSettings.getInstance());
        List customCandidates = ContainerUtil.findAll((Object[])CustomLiveTemplate.EP_NAME.getExtensions(), customLiveTemplate -> shortcutChar == customLiveTemplate.getShortcut() && (editor.getCaretModel().getCaretCount() <= 1 || TemplateManagerImpl.supportsMultiCaretMode(customLiveTemplate)));
        if (!customCandidates.isEmpty()) {
            int caretOffset = editor.getCaretModel().getOffset();
            PsiFile fileCopy = TemplateManagerImpl.insertDummyIdentifierWithCache(file2, caretOffset, caretOffset, "").getFile();
            Document document = editor.getDocument();
            for (CustomLiveTemplate customLiveTemplate2 : customCandidates) {
                String key;
                if (!TemplateManagerImpl.isApplicable(customLiveTemplate2, editor, fileCopy) || (key = customLiveTemplate2.computeTemplateKey(new CustomTemplateCallback(editor, fileCopy))) == null) continue;
                int offsetBeforeKey = caretOffset - key.length();
                CharSequence text2 = document.getImmutableCharSequence();
                if (template2argument != null && TemplateManagerImpl.containsTemplateStartingBefore(template2argument, offsetBeforeKey, caretOffset, text2)) continue;
                return () -> customLiveTemplate2.expand(key, new CustomTemplateCallback(editor, file2));
            }
        }
        return this.startNonCustomTemplates(template2argument, editor, processor2);
    }

    private static boolean supportsMultiCaretMode(CustomLiveTemplate customLiveTemplate) {
        return !(customLiveTemplate instanceof CustomLiveTemplateBase) || ((CustomLiveTemplateBase)customLiveTemplate).supportsMultiCaret();
    }

    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (customLiveTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customLiveTemplate", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "isApplicable"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "isApplicable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "isApplicable"));
        }
        return TemplateManagerImpl.isApplicable(customLiveTemplate, editor, file2, false);
    }

    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull Editor editor, @NotNull PsiFile file2, boolean wrapping) {
        if (customLiveTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customLiveTemplate", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "isApplicable"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "isApplicable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "isApplicable"));
        }
        return customLiveTemplate.isApplicable(file2, CustomTemplateCallback.getOffset(editor), wrapping);
    }

    private static int getArgumentOffset(int caretOffset, String argument, CharSequence text2) {
        int argumentOffset = caretOffset - argument.length();
        if (argumentOffset > 0 && text2.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text2.charAt(argumentOffset - 2))) {
            --argumentOffset;
        }
        return argumentOffset;
    }

    private static int getTemplateStart(TemplateImpl template, String argument, int caretOffset, CharSequence text2) {
        int templateStart;
        if (argument == null) {
            templateStart = caretOffset - template.getKey().length();
        } else {
            int argOffset = TemplateManagerImpl.getArgumentOffset(caretOffset, argument, text2);
            templateStart = argOffset - template.getKey().length();
        }
        return templateStart;
    }

    public Map<TemplateImpl, String> findMatchingTemplates(PsiFile file2, Editor editor, @Nullable Character shortcutChar, TemplateSettings templateSettings) {
        List<TemplateImpl> candidatesWithArgument;
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int caretOffset = editor.getCaretModel().getOffset();
        List<TemplateImpl> candidatesWithoutArgument = TemplateManagerImpl.findMatchingTemplates(text2, caretOffset, shortcutChar, templateSettings, false);
        int argumentOffset = TemplateManagerImpl.passArgumentBack(text2, caretOffset);
        String argument = null;
        if (argumentOffset >= 0) {
            argument = text2.subSequence(argumentOffset, caretOffset).toString();
            if (argumentOffset > 0 && text2.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text2.charAt(argumentOffset - 2))) {
                --argumentOffset;
            }
        }
        if ((candidatesWithArgument = TemplateManagerImpl.findMatchingTemplates(text2, argumentOffset, shortcutChar, templateSettings, true)).isEmpty() && candidatesWithoutArgument.isEmpty()) {
            return null;
        }
        candidatesWithoutArgument = TemplateManagerImpl.filterApplicableCandidates(file2, caretOffset, candidatesWithoutArgument);
        candidatesWithArgument = TemplateManagerImpl.filterApplicableCandidates(file2, argumentOffset, candidatesWithArgument);
        HashMap candidate2Argument = new HashMap();
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithoutArgument, null);
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithArgument, argument);
        return candidate2Argument;
    }

    @Nullable
    public Runnable startNonCustomTemplates(Map<TemplateImpl, String> template2argument, Editor editor, @Nullable PairProcessor<String, String> processor2) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        if (template2argument == null || template2argument.isEmpty()) {
            return null;
        }
        return () -> {
            if (template2argument.size() == 1) {
                TemplateImpl template = (TemplateImpl)template2argument.keySet().iterator().next();
                String argument = (String)template2argument.get(template);
                int templateStart = TemplateManagerImpl.getTemplateStart(template, argument, caretOffset, text2);
                this.startTemplateWithPrefix(editor, template, templateStart, processor2, argument);
            } else {
                ListTemplatesHandler.showTemplatesLookup(this.myProject, editor, template2argument);
            }
        };
    }

    public static List<TemplateImpl> findMatchingTemplates(CharSequence text2, int caretOffset, @Nullable Character shortcutChar, TemplateSettings settings, boolean hasArgument) {
        String key;
        int wordStart;
        List<TemplateImpl> candidates = Collections.emptyList();
        for (int i2 = settings.getMaxKeyLength(); i2 >= 1 && ((wordStart = caretOffset - i2) < 0 || Character.isJavaIdentifierStart((key = text2.subSequence(wordStart, caretOffset).toString()).charAt(0)) && wordStart > 0 && Character.isJavaIdentifierPart(text2.charAt(wordStart - 1)) || (candidates = settings.collectMatchingCandidates(key, shortcutChar, hasArgument)).isEmpty()); --i2) {
        }
        return candidates;
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, @Nullable PairProcessor<String, String> processor2, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        String key = template.getKey();
        int startOffset = caretOffset - key.length();
        if (argument != null) {
            if (!TemplateManagerImpl.isDelimiter(key.charAt(key.length() - 1))) {
                --startOffset;
            }
            startOffset -= argument.length();
        }
        this.startTemplateWithPrefix(editor, template, startOffset, processor2, argument);
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, int templateStart, @Nullable PairProcessor<String, String> processor2, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        TemplateState templateState = this.initTemplateState(editor);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            editor.getDocument().deleteString(templateStart, caretOffset);
            editor.getCaretModel().moveToOffset(templateStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            HashMap predefinedVarValues = null;
            if (argument != null) {
                predefinedVarValues = new HashMap();
                predefinedVarValues.put("ARG", argument);
            }
            templateState.start(template, processor2, (Map<String, String>)predefinedVarValues);
        }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
    }

    private static List<TemplateImpl> filterApplicableCandidates(PsiFile file2, int caretOffset, List<TemplateImpl> candidates) {
        if (candidates.isEmpty()) {
            return candidates;
        }
        PsiFile copy = TemplateManagerImpl.insertDummyIdentifierWithCache(file2, caretOffset, caretOffset, CompletionUtil.DUMMY_IDENTIFIER_TRIMMED).getFile();
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : candidates) {
            if (!TemplateManagerImpl.isApplicable(copy, caretOffset - candidate.getKey().length(), candidate)) continue;
            result2.add(candidate);
        }
        return result2;
    }

    private static List<TemplateContextType> getBases(TemplateContextType type) {
        ArrayList<TemplateContextType> list2 = new ArrayList<TemplateContextType>();
        while ((type = type.getBaseContextType()) != null) {
            list2.add(type);
        }
        return list2;
    }

    private static Set<TemplateContextType> getDirectlyApplicableContextTypes(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "getDirectlyApplicableContextTypes"));
        }
        LinkedHashSet<TemplateContextType> set2 = new LinkedHashSet<TemplateContextType>();
        LinkedList<TemplateContextType> contexts = TemplateManagerImpl.buildOrderedContextTypes();
        for (TemplateContextType contextType : contexts) {
            if (!contextType.isInContext(file2, offset)) continue;
            set2.add(contextType);
        }
        block1: while (true) {
            for (TemplateContextType type : set2) {
                if (!set2.removeAll(TemplateManagerImpl.getBases(type))) continue;
                continue block1;
            }
            break;
        }
        return set2;
    }

    private static LinkedList<TemplateContextType> buildOrderedContextTypes() {
        TemplateContextType[] typeCollection = TemplateManagerImpl.getAllContextTypes();
        LinkedList<TemplateContextType> userDefinedExtensionsFirst = new LinkedList<TemplateContextType>();
        for (TemplateContextType contextType : typeCollection) {
            if (contextType.getClass().getName().startsWith(Template.class.getPackage().getName())) {
                userDefinedExtensionsFirst.addLast(contextType);
                continue;
            }
            userDefinedExtensionsFirst.addFirst(contextType);
        }
        return userDefinedExtensionsFirst;
    }

    public static TemplateContextType[] getAllContextTypes() {
        return ourContextTypes;
    }

    @Override
    @Nullable
    public Template getActiveTemplate(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "getActiveTemplate"));
        }
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        return templateState != null ? templateState.getTemplate() : null;
    }

    @Override
    public boolean finishTemplate(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "finishTemplate"));
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null) {
            state.gotoEnd();
            return true;
        }
        return false;
    }

    public static boolean isApplicable(PsiFile file2, int offset, TemplateImpl template) {
        return TemplateManagerImpl.isApplicable(template, TemplateManagerImpl.getApplicableContextTypes(file2, offset));
    }

    public static boolean isApplicable(TemplateImpl template, Set<TemplateContextType> contextTypes) {
        for (TemplateContextType type : contextTypes) {
            if (!template.getTemplateContext().isEnabled(type)) continue;
            return true;
        }
        return false;
    }

    public static List<TemplateImpl> listApplicableTemplates(PsiFile file2, int offset, boolean selectionOnly) {
        Set<TemplateContextType> contextTypes = TemplateManagerImpl.getApplicableContextTypes(file2, offset);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
            if (template.isDeactivated() || selectionOnly && !template.isSelectionTemplate() || !TemplateManagerImpl.isApplicable(template, contextTypes)) continue;
            result2.add(template);
        }
        return result2;
    }

    public static List<TemplateImpl> listApplicableTemplateWithInsertingDummyIdentifier(Editor editor, PsiFile file2, boolean selectionOnly) {
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        OffsetsInFile offsets = TemplateManagerImpl.insertDummyIdentifierWithCache(file2, startOffset, endOffset, CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
        return TemplateManagerImpl.listApplicableTemplates(offsets.getFile(), TemplateManagerImpl.getStartOffset(offsets), selectionOnly);
    }

    public static List<CustomLiveTemplate> listApplicableCustomTemplates(@NotNull Editor editor, @NotNull PsiFile file2, boolean selectionOnly) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "listApplicableCustomTemplates"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "listApplicableCustomTemplates"));
        }
        ArrayList<CustomLiveTemplate> result2 = new ArrayList<CustomLiveTemplate>();
        for (CustomLiveTemplate template : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            if (selectionOnly && !template.supportsWrapping() || !TemplateManagerImpl.isApplicable(template, editor, file2, selectionOnly)) continue;
            result2.add(template);
        }
        return result2;
    }

    public static Set<TemplateContextType> getApplicableContextTypes(PsiFile file2, int offset) {
        PsiFile basePsi;
        Language languageAtOffset;
        PsiFile basePsi2;
        Set<TemplateContextType> result2 = TemplateManagerImpl.getDirectlyApplicableContextTypes(file2, offset);
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        if (baseLanguage != file2.getLanguage() && (basePsi2 = file2.getViewProvider().getPsi(baseLanguage)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(basePsi2, offset));
        }
        if ((languageAtOffset = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset)) != file2.getLanguage() && languageAtOffset != baseLanguage && (basePsi = file2.getViewProvider().getPsi(languageAtOffset)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(basePsi, offset));
        }
        return result2;
    }

    private static int getStartOffset(OffsetsInFile offsets) {
        return offsets.getOffsets().getOffset(START_OFFSET);
    }

    private static int getEndOffset(OffsetsInFile offsets) {
        return offsets.getOffsets().getOffset(END_OFFSET);
    }

    private static OffsetsInFile insertDummyIdentifierWithCache(PsiFile file2, int startOffset, int endOffset, String replacement) {
        ProperTextRange editRange = ProperTextRange.create((int)startOffset, (int)endOffset);
        TemplateManagerImpl.assertRangeWithinDocument(editRange, file2.getViewProvider().getDocument());
        ConcurrentFactoryMap map2 = (ConcurrentFactoryMap)CachedValuesManager.getCachedValue((PsiElement)file2, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createConcurrentMap(key -> TemplateManagerImpl.copyWithDummyIdentifier(new OffsetsInFile(file2), ((ProperTextRange)key.first).getStartOffset(), ((ProperTextRange)key.first).getEndOffset(), (String)key.second)), (Object[])new Object[]{file2, file2.getViewProvider().getDocument()}));
        return (OffsetsInFile)map2.get((Object)Pair.create((Object)editRange, (Object)replacement));
    }

    private static void assertRangeWithinDocument(ProperTextRange editRange, Document document) {
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        assert (docRange.contains((TextRange)editRange)) : docRange + " doesn't contain " + editRange;
    }

    @NotNull
    public static OffsetsInFile copyWithDummyIdentifier(OffsetsInFile offsetMap, int startOffset, int endOffset, String replacement) {
        offsetMap.getOffsets().addOffset(START_OFFSET, startOffset);
        offsetMap.getOffsets().addOffset(END_OFFSET, endOffset);
        Document document = offsetMap.getFile().getViewProvider().getDocument();
        assert (document != null);
        if (replacement.isEmpty() && startOffset == endOffset && PsiDocumentManager.getInstance((Project)offsetMap.getFile().getProject()).isCommitted(document)) {
            OffsetsInFile offsetsInFile = offsetMap;
            if (offsetsInFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "copyWithDummyIdentifier"));
            }
            return offsetsInFile;
        }
        OffsetsInFile hostOffsets = offsetMap.toTopLevelFile();
        OffsetsInFile hostCopy = hostOffsets.copyWithReplacement(TemplateManagerImpl.getStartOffset(hostOffsets), TemplateManagerImpl.getEndOffset(hostOffsets), replacement);
        OffsetsInFile offsetsInFile = hostCopy.toInjectedIfAny(TemplateManagerImpl.getStartOffset(hostCopy));
        if (offsetsInFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateManagerImpl", "copyWithDummyIdentifier"));
        }
        return offsetsInFile;
    }
}

