/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import java.util.ArrayList;

public class TemplateSegments {
    private final ArrayList<RangeMarker> mySegments = new ArrayList();
    private final Editor myEditor;

    public TemplateSegments(Editor editor) {
        this.myEditor = editor;
    }

    public int getSegmentStart(int i2) {
        RangeMarker rangeMarker = this.mySegments.get(i2);
        return rangeMarker.getStartOffset();
    }

    public int getSegmentEnd(int i2) {
        RangeMarker rangeMarker = this.mySegments.get(i2);
        return rangeMarker.getEndOffset();
    }

    public boolean isValid(int i2) {
        return this.mySegments.get(i2).isValid();
    }

    public void removeAll() {
        for (RangeMarker segment : this.mySegments) {
            segment.dispose();
        }
        this.mySegments.clear();
    }

    public void addSegment(int start2, int end) {
        RangeMarker rangeMarker = this.myEditor.getDocument().createRangeMarker(start2, end);
        this.mySegments.add(rangeMarker);
    }

    public void setSegmentsGreedy(boolean greedy) {
        for (RangeMarker segment : this.mySegments) {
            segment.setGreedyToRight(greedy);
            segment.setGreedyToLeft(greedy);
        }
    }

    public boolean isInvalid() {
        for (RangeMarker marker : this.mySegments) {
            if (marker.isValid()) continue;
            return true;
        }
        return false;
    }

    public void replaceSegmentAt(int index, int start2, int end) {
        this.replaceSegmentAt(index, start2, end, false);
    }

    public void replaceSegmentAt(int index, int start2, int end, boolean preserveGreediness) {
        RangeMarker rangeMarker = this.mySegments.get(index);
        boolean greedyToLeft = rangeMarker.isGreedyToLeft();
        boolean greedyToRight = rangeMarker.isGreedyToRight();
        rangeMarker.dispose();
        Document doc = this.myEditor.getDocument();
        rangeMarker = doc.createRangeMarker(start2, end);
        rangeMarker.setGreedyToLeft(greedyToLeft || !preserveGreediness);
        rangeMarker.setGreedyToRight(greedyToRight || !preserveGreediness);
        this.mySegments.set(index, rangeMarker);
    }

    public void setNeighboursGreedy(int segmentNumber, boolean greedy) {
        if (segmentNumber > 0) {
            RangeMarker left = this.mySegments.get(segmentNumber - 1);
            left.setGreedyToLeft(greedy);
            left.setGreedyToRight(greedy);
        }
        if (segmentNumber + 1 < this.mySegments.size()) {
            RangeMarker right = this.mySegments.get(segmentNumber + 1);
            right.setGreedyToLeft(greedy);
            right.setGreedyToRight(greedy);
        }
    }

    public void lockSegmentAtTheSameOffsetIfAny(int number) {
        if (number == -1) {
            return;
        }
        RangeMarker current = this.mySegments.get(number);
        int offset = current.getStartOffset();
        for (int i2 = 0; i2 < this.mySegments.size(); ++i2) {
            RangeMarker segment;
            int startOffset2;
            if (i2 == number || offset != (startOffset2 = (segment = this.mySegments.get(i2)).getStartOffset())) continue;
            segment.setGreedyToLeft(false);
        }
    }

    public int getSegmentsCount() {
        return this.mySegments.size();
    }
}

