/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.MacroParser;
import com.intellij.codeInsight.template.impl.SelectionNode;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Variable
implements Cloneable {
    private final String myName;
    private boolean myAlwaysStopAt;
    @Nullable
    private String myExpressionString;
    private Expression myExpression;
    private String myDefaultValueString;
    private Expression myDefaultValueExpression;
    private final boolean mySkipOnStart;

    public Variable(@NotNull String name, @Nullable Expression expression, @Nullable Expression defaultValueExpression, boolean alwaysStopAt, boolean skipOnStart) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/Variable", "<init>"));
        }
        this.myExpression = null;
        this.myName = name;
        this.myExpression = expression;
        this.myDefaultValueExpression = defaultValueExpression;
        this.myAlwaysStopAt = alwaysStopAt;
        this.mySkipOnStart = skipOnStart;
    }

    public Variable(@NotNull String name, @Nullable String expression, @Nullable String defaultValueString, boolean alwaysStopAt) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/Variable", "<init>"));
        }
        this.myExpression = null;
        this.myName = name;
        this.myExpressionString = StringUtil.notNullize((String)expression);
        this.myDefaultValueString = StringUtil.notNullize((String)defaultValueString);
        this.myAlwaysStopAt = alwaysStopAt;
        this.mySkipOnStart = false;
    }

    @NotNull
    public String getExpressionString() {
        String string2 = StringUtil.notNullize((String)this.myExpressionString);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/Variable", "getExpressionString"));
        }
        return string2;
    }

    public void setExpressionString(@Nullable String expressionString) {
        this.myExpressionString = expressionString;
        this.myExpression = null;
    }

    @NotNull
    public Expression getExpression() {
        if (this.myExpression == null) {
            this.myExpression = this.myName.equals("SELECTION") ? new SelectionNode() : MacroParser.parse(this.myExpressionString);
        }
        Expression expression = this.myExpression;
        if (expression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/Variable", "getExpression"));
        }
        return expression;
    }

    @NotNull
    public String getDefaultValueString() {
        String string2 = StringUtil.notNullize((String)this.myDefaultValueString);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/Variable", "getDefaultValueString"));
        }
        return string2;
    }

    public void setDefaultValueString(@Nullable String defaultValueString) {
        this.myDefaultValueString = defaultValueString;
        this.myDefaultValueExpression = null;
    }

    @NotNull
    public Expression getDefaultValueExpression() {
        if (this.myDefaultValueExpression == null) {
            this.myDefaultValueExpression = MacroParser.parse(this.myDefaultValueString);
        }
        Expression expression = this.myDefaultValueExpression;
        if (expression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/Variable", "getDefaultValueExpression"));
        }
        return expression;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/Variable", "getName"));
        }
        return string2;
    }

    public boolean isAlwaysStopAt() {
        if (this.myName.equals("SELECTION")) {
            return false;
        }
        return this.myAlwaysStopAt;
    }

    public void setAlwaysStopAt(boolean alwaysStopAt) {
        this.myAlwaysStopAt = alwaysStopAt;
    }

    public Object clone() {
        return new Variable(this.myName, this.myExpressionString, this.myDefaultValueString, this.myAlwaysStopAt);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)o2;
        if (this.myAlwaysStopAt != variable.myAlwaysStopAt) {
            return false;
        }
        if (this.mySkipOnStart != variable.mySkipOnStart) {
            return false;
        }
        if (this.myDefaultValueString != null ? !this.myDefaultValueString.equals(variable.myDefaultValueString) : variable.myDefaultValueString != null) {
            return false;
        }
        if (this.myExpressionString != null ? !this.myExpressionString.equals(variable.myExpressionString) : variable.myExpressionString != null) {
            return false;
        }
        return this.myName.equals(variable.myName);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 29 * result2 + (this.myAlwaysStopAt ? 1 : 0);
        result2 = 29 * result2 + (this.mySkipOnStart ? 1 : 0);
        result2 = 29 * result2 + (this.myExpressionString != null ? this.myExpressionString.hashCode() : 0);
        result2 = 29 * result2 + (this.myDefaultValueString != null ? this.myDefaultValueString.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Variable{myName='" + this.myName + '\'' + ", myAlwaysStopAt=" + this.myAlwaysStopAt + ", myExpressionString='" + this.myExpressionString + '\'' + ", myDefaultValueString='" + this.myDefaultValueString + '\'' + ", mySkipOnStart=" + this.mySkipOnStart + '}';
    }

    public boolean skipOnStart() {
        return this.mySkipOnStart;
    }
}

