/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import org.jetbrains.annotations.Nullable;

public class VariableNode
extends Expression {
    private final String myName;
    private final Expression myInitialValue;

    public VariableNode(String name, @Nullable Expression initialValue) {
        this.myName = name;
        this.myInitialValue = initialValue;
    }

    public Result calculateResult(ExpressionContext context2) {
        if (this.myInitialValue != null) {
            return this.myInitialValue.calculateResult(context2);
        }
        return TemplateManagerImpl.getTemplateState(context2.getEditor()).getVariableValue(this.getName());
    }

    public Result calculateQuickResult(ExpressionContext context2) {
        if (this.myInitialValue != null) {
            return this.myInitialValue.calculateQuickResult(context2);
        }
        return TemplateManagerImpl.getTemplateState(context2.getEditor()).getVariableValue(this.getName());
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context2) {
        if (this.myInitialValue == null) {
            return null;
        }
        return this.myInitialValue.calculateLookupItems(context2);
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public Expression getInitialValue() {
        return this.myInitialValue;
    }
}

