/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToCamelCaseMacro
extends MacroBase {
    public ConvertToCamelCaseMacro() {
        super("camelCase", "camelCase(String)");
    }

    private ConvertToCamelCaseMacro(String name, String description) {
        super(name, description);
    }

    @Override
    @Nullable
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context2, boolean quick) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro", "calculateResult"));
        }
        String text2 = ConvertToCamelCaseMacro.getTextResult(params, context2, true);
        return text2 != null ? this.convertString(text2) : null;
    }

    @NotNull
    @VisibleForTesting
    public Result convertString(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro", "convertString"));
        }
        String[] strings = this.splitWords(text2);
        if (strings.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(strings[0].toLowerCase());
            for (int i2 = 1; i2 < strings.length; ++i2) {
                String string2 = strings[i2];
                if (!Character.isLetterOrDigit(string2.charAt(0))) continue;
                buf.append(StringUtil.capitalize((String)string2.toLowerCase()));
            }
            TextResult textResult = new TextResult(buf.toString());
            if (textResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro", "convertString"));
            }
            return textResult;
        }
        TextResult textResult = new TextResult("");
        if (textResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro", "convertString"));
        }
        return textResult;
    }

    @NotNull
    protected String[] splitWords(String text2) {
        String[] stringArray = NameUtil.nameToWords((String)text2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro", "splitWords"));
        }
        return stringArray;
    }

    public static class ReplaceUnderscoresToCamelCaseMacro
    extends ConvertToCamelCaseMacro {
        public ReplaceUnderscoresToCamelCaseMacro() {
            super("underscoresToCamelCase", CodeInsightBundle.message((String)"macro.undescoresToCamelCase.string", (Object[])new Object[0]));
        }

        @Override
        @NotNull
        protected String[] splitWords(String text2) {
            String[] stringArray = text2.split("_");
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ConvertToCamelCaseMacro$ReplaceUnderscoresToCamelCaseMacro", "splitWords"));
            }
            return stringArray;
        }
    }
}

