/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNameMacro
extends Macro {
    public String getName() {
        return "fileName";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.file.name", (Object[])new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context2) {
        VirtualFile virtualFile;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/FileNameMacro", "calculateResult"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)context2.getProject()).getPsiFile(context2.getEditor().getDocument());
        if (file2 != null && (virtualFile = file2.getVirtualFile()) != null) {
            return this.calculateResult(virtualFile);
        }
        return null;
    }

    @Nullable
    protected TextResult calculateResult(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/template/macro/FileNameMacro", "calculateResult"));
        }
        return new TextResult(virtualFile.getName());
    }
}

