/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PostfixTemplateWithExpressionSelector
extends PostfixTemplate {
    @NotNull
    private final PostfixTemplateExpressionSelector mySelector;

    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String key, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        super(name, key, example);
        this.mySelector = selector;
    }

    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        if (example == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "example", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "<init>"));
        }
        super(name, example);
        this.mySelector = selector;
    }

    @Override
    public final boolean isApplicable(@NotNull PsiElement context2, @NotNull Document copyDocument, int newOffset) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "isApplicable"));
        }
        return this.mySelector.hasExpression(context2, copyDocument, newOffset);
    }

    @Override
    public final void expand(@NotNull PsiElement context2, final @NotNull Editor editor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "expand"));
        }
        List<PsiElement> expressions = this.mySelector.getExpressions(context2, editor.getDocument(), editor.getCaretModel().getOffset());
        if (expressions.isEmpty()) {
            PostfixTemplatesUtils.showErrorHint(context2.getProject(), editor);
            return;
        }
        if (expressions.size() == 1) {
            this.prepareAndExpandForChooseExpression(expressions.get(0), editor);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement item = (PsiElement)ContainerUtil.getLastItem(expressions);
            assert (item != null);
            this.prepareAndExpandForChooseExpression(item, editor);
            return;
        }
        IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement e2) {
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector$1", "pass"));
                }
                PostfixTemplateWithExpressionSelector.this.prepareAndExpandForChooseExpression(e2, editor);
            }
        }, this.mySelector.getRenderer(), "Expressions", 0, ScopeHighlighter.NATURAL_RANGER);
    }

    protected void prepareAndExpandForChooseExpression(@NotNull PsiElement expression, @NotNull Editor editor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "prepareAndExpandForChooseExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "prepareAndExpandForChooseExpression"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "lambda$prepareAndExpandForChooseExpression$1"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "lambda$prepareAndExpandForChooseExpression$1"));
            }
            CommandProcessor.getInstance().executeCommand(expression.getProject(), () -> {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "lambda$null$0"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateWithExpressionSelector", "lambda$null$0"));
                }
                this.expandForChooseExpression(expression, editor);
            }, "Expand postfix template", (Object)"POSTFIX_TEMPLATE_ID");
        });
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    protected abstract void expandForChooseExpression(@NotNull PsiElement var1, @NotNull Editor var2);
}

