/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class SurroundPostfixTemplateBase
extends PostfixTemplateWithExpressionSelector {
    @NotNull
    protected final PostfixTemplatePsiInfo myPsiInfo;

    protected SurroundPostfixTemplateBase(@NotNull String name, @NotNull String descr, @NotNull PostfixTemplatePsiInfo psiInfo, @NotNull PostfixTemplateExpressionSelector selector) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "<init>"));
        }
        if (descr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descr", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "<init>"));
        }
        if (psiInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiInfo", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "<init>"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "<init>"));
        }
        super(name, descr, selector);
        this.myPsiInfo = psiInfo;
    }

    @Override
    public final void expandForChooseExpression(@NotNull PsiElement context2, @NotNull Editor editor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "expandForChooseExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "expandForChooseExpression"));
        }
        PsiElement replace = this.getReplacedExpression(context2);
        TextRange range = PostfixTemplatesUtils.surround(this.getSurrounder(), editor, replace);
        if (range != null) {
            editor.getCaretModel().moveToOffset(range.getStartOffset());
        }
    }

    protected PsiElement getReplacedExpression(PsiElement topmostExpression) {
        PsiElement expression = this.getWrappedExpression(topmostExpression);
        assert (topmostExpression != null);
        return topmostExpression.replace(expression);
    }

    protected PsiElement getWrappedExpression(PsiElement expression) {
        if (StringUtil.isEmpty((String)this.getHead()) && StringUtil.isEmpty((String)this.getTail())) {
            return expression;
        }
        return this.createNew(expression);
    }

    protected PsiElement createNew(PsiElement expression) {
        return this.myPsiInfo.createExpression(expression, this.getHead(), this.getTail());
    }

    @NotNull
    protected String getHead() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "getHead"));
        }
        return "";
    }

    @NotNull
    protected String getTail() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/SurroundPostfixTemplateBase", "getTail"));
        }
        return "";
    }

    @NotNull
    protected abstract Surrounder getSurrounder();
}

