/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractUnwrapper<C extends AbstractContext>
implements Unwrapper {
    private final String myDescription;

    public AbstractUnwrapper(String description) {
        this.myDescription = description;
    }

    @Override
    public abstract boolean isApplicableTo(PsiElement var1);

    @Override
    public void collectElementsToIgnore(PsiElement element, Set<PsiElement> result2) {
    }

    @Override
    public String getDescription(PsiElement e2) {
        return this.myDescription;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e2, List<PsiElement> toExtract) {
        try {
            C c2 = this.createContext();
            this.doUnwrap(e2, c2);
            toExtract.addAll(((AbstractContext)c2).myElementsToExtract);
            return e2;
        }
        catch (IncorrectOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<PsiElement> unwrap(Editor editor, PsiElement element) throws IncorrectOperationException {
        C c2 = this.createContext();
        ((AbstractContext)c2).myIsEffective = true;
        this.doUnwrap(element, c2);
        return ((AbstractContext)c2).myElementsToExtract;
    }

    protected abstract void doUnwrap(PsiElement var1, C var2) throws IncorrectOperationException;

    protected abstract C createContext();

    public static abstract class AbstractContext {
        protected final List<PsiElement> myElementsToExtract = new ArrayList<PsiElement>();
        protected boolean myIsEffective;

        public void addElementToExtract(PsiElement e2) {
            this.myElementsToExtract.add(e2);
        }

        public void extractElement(PsiElement element, PsiElement from) throws IncorrectOperationException {
            this.extract(element, element, from);
        }

        protected abstract boolean isWhiteSpace(PsiElement var1);

        protected void extract(PsiElement first, PsiElement last, PsiElement from) throws IncorrectOperationException {
            while (first != last && this.isWhiteSpace(first)) {
                first = first.getNextSibling();
            }
            while (last != first && this.isWhiteSpace(last)) {
                last = last.getPrevSibling();
            }
            if (first == null || last == null || first == last && this.isWhiteSpace(last)) {
                return;
            }
            PsiElement toExtract = first;
            if (this.myIsEffective) {
                toExtract = from.getParent().addRangeBefore(first, last, from);
            }
            do {
                if (toExtract == null) continue;
                this.addElementToExtract(toExtract);
                toExtract = toExtract.getNextSibling();
            } while ((first = first.getNextSibling()) != null && first.getPrevSibling() != last);
        }

        public void delete(PsiElement e2) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e2.delete();
            }
        }

        public void deleteExactly(PsiElement e2) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e2.getParent().deleteChildRange(e2, e2);
            }
        }
    }
}

