/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.RangeSplitter;
import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScopeHighlighter {
    public static final NotNullFunction<PsiElement, TextRange> NATURAL_RANGER = dom -> dom.getTextRange();
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final List<RangeHighlighter> myActiveHighliters;
    @NotNull
    private final NotNullFunction<PsiElement, TextRange> myRanger;

    public ScopeHighlighter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/unwrap/ScopeHighlighter", "<init>"));
        }
        this(editor, NATURAL_RANGER);
    }

    public ScopeHighlighter(@NotNull Editor editor, @NotNull NotNullFunction<PsiElement, TextRange> ranger) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/unwrap/ScopeHighlighter", "<init>"));
        }
        if (ranger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranger", "com/intellij/codeInsight/unwrap/ScopeHighlighter", "<init>"));
        }
        this.myActiveHighliters = new ArrayList<RangeHighlighter>();
        this.myEditor = editor;
        this.myRanger = ranger;
    }

    public void highlight(@NotNull PsiElement wholeAffected, @NotNull List<PsiElement> toExtract) {
        if (wholeAffected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wholeAffected", "com/intellij/codeInsight/unwrap/ScopeHighlighter", "highlight"));
        }
        if (toExtract == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toExtract", "com/intellij/codeInsight/unwrap/ScopeHighlighter", "highlight"));
        }
        Pair<TextRange, List<TextRange>> ranges = this.collectTextRanges(wholeAffected, toExtract);
        this.highlight(ranges);
    }

    public void highlight(@NotNull Pair<TextRange, List<TextRange>> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/unwrap/ScopeHighlighter", "highlight"));
        }
        this.dropHighlight();
        TextRange wholeRange = (TextRange)ranges.first;
        List rangesToExtract = (List)ranges.second;
        List<TextRange> rangesToRemove = RangeSplitter.split(wholeRange, rangesToExtract);
        for (TextRange r2 : rangesToRemove) {
            this.addHighlighter(r2, 6001, ScopeHighlighter.getTestAttributesForRemoval());
        }
        for (TextRange r2 : rangesToExtract) {
            this.addHighlighter(r2, 6001, UnwrapHandler.getTestAttributesForExtract());
        }
    }

    private Pair<TextRange, List<TextRange>> collectTextRanges(PsiElement wholeElement, List<PsiElement> elementsToExtract) {
        TextRange affectedRange = this.getRange(wholeElement);
        ArrayList<TextRange> rangesToExtract = new ArrayList<TextRange>();
        for (PsiElement e2 : elementsToExtract) {
            rangesToExtract.add(this.getRange(e2));
        }
        return Pair.create((Object)affectedRange, rangesToExtract);
    }

    private TextRange getRange(PsiElement e2) {
        return (TextRange)this.myRanger.fun((Object)e2);
    }

    private void addHighlighter(TextRange r2, int level, TextAttributes attr) {
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        RangeHighlighter highlighter2 = markupModel.addRangeHighlighter(r2.getStartOffset(), r2.getEndOffset(), level, attr, HighlighterTargetArea.EXACT_RANGE);
        this.myActiveHighliters.add(highlighter2);
    }

    public void dropHighlight() {
        for (RangeHighlighter h2 : this.myActiveHighliters) {
            h2.dispose();
        }
        this.myActiveHighliters.clear();
    }

    private static TextAttributes getTestAttributesForRemoval() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.DELETED_TEXT_ATTRIBUTES);
    }
}

