/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionApplication;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.application.ApplicationStarter;
import java.util.Arrays;

public class InspectionMain
implements ApplicationStarter {
    private InspectionApplication myApplication;

    public String getCommandName() {
        return "inspect";
    }

    public void premain(String[] args) {
        if (args.length < 4) {
            System.err.println("invalid args:" + Arrays.toString(args));
            InspectionMain.printHelp();
        }
        this.myApplication = new InspectionApplication();
        this.myApplication.myHelpProvider = new InspectionToolCmdlineOptionHelpProvider(){

            @Override
            public void printHelpAndExit() {
                InspectionMain.printHelp();
            }
        };
        this.myApplication.myProjectPath = args[1];
        this.myApplication.myStubProfile = args[2];
        this.myApplication.myOutPath = args[3];
        if (this.myApplication.myProjectPath == null || this.myApplication.myOutPath == null || this.myApplication.myStubProfile == null) {
            System.err.println(this.myApplication.myProjectPath + this.myApplication.myOutPath + this.myApplication.myStubProfile);
            InspectionMain.printHelp();
        }
        try {
            for (int i2 = 4; i2 < args.length; ++i2) {
                String arg = args[i2];
                if ("-profileName".equals(arg)) {
                    this.myApplication.myProfileName = args[++i2];
                    continue;
                }
                if ("-profilePath".equals(arg)) {
                    this.myApplication.myProfilePath = args[++i2];
                    continue;
                }
                if ("-d".equals(arg)) {
                    this.myApplication.mySourceDirectory = args[++i2];
                    continue;
                }
                if ("-v0".equals(arg)) {
                    this.myApplication.setVerboseLevel(0);
                    continue;
                }
                if ("-v1".equals(arg)) {
                    this.myApplication.setVerboseLevel(1);
                    continue;
                }
                if ("-v2".equals(arg)) {
                    this.myApplication.setVerboseLevel(2);
                    continue;
                }
                if ("-v3".equals(arg)) {
                    this.myApplication.setVerboseLevel(3);
                    continue;
                }
                if ("-e".equals(arg)) {
                    this.myApplication.myRunWithEditorSettings = true;
                    continue;
                }
                if ("-t".equals(arg)) {
                    this.myApplication.myErrorCodeRequired = false;
                    continue;
                }
                System.err.println("unexpected argument: " + arg);
                InspectionMain.printHelp();
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            InspectionMain.printHelp();
        }
        this.myApplication.myRunGlobalToolsOnly = System.getProperty("idea.no.local.inspections") != null;
    }

    public void main(String[] args) {
        this.myApplication.startup();
    }

    public static void printHelp() {
        System.out.println(InspectionsBundle.message((String)"inspection.command.line.explanation", (Object[])new Object[0]));
        System.exit(1);
    }
}

